/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.concurrent;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.ThreadLocalRandom;
import sun.misc.Unsafe;

class ThreadLocalRandomUtil {
    static final Unsafe UNSAFE = ThreadLocalRandomUtil.getSMU();
    private static final long PROBE;

    ThreadLocalRandomUtil() {
    }

    static Unsafe getSMU() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(() -> {
                    Class<Unsafe> k = Unsafe.class;
                    for (Field f : k.getDeclaredFields()) {
                        f.setAccessible(true);
                        Object x = f.get(null);
                        if (!k.isInstance(x)) continue;
                        return (Unsafe)k.cast(x);
                    }
                    throw new NoSuchFieldError("the Unsafe");
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static final int getProbe() {
        return UNSAFE.getInt(Thread.currentThread(), PROBE);
    }

    static final int advanceProbe(int probe) {
        probe ^= probe << 13;
        probe ^= probe >>> 17;
        probe ^= probe << 5;
        UNSAFE.putInt(Thread.currentThread(), PROBE, probe);
        return probe;
    }

    static final void localInit() {
        ThreadLocalRandom.current();
    }

    static {
        try {
            Class<Thread> tk = Thread.class;
            PROBE = UNSAFE.objectFieldOffset(tk.getDeclaredField("threadLocalRandomProbe"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

