/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Clock;
import com.google.api.core.ApiFuture;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.DeleteUsersResult;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseToken;
import com.google.firebase.auth.FirebaseTokenUtils;
import com.google.firebase.auth.FirebaseTokenVerifier;
import com.google.firebase.auth.FirebaseUserManager;
import com.google.firebase.auth.GetUsersResult;
import com.google.firebase.auth.ImportUserRecord;
import com.google.firebase.auth.ListProviderConfigsPage;
import com.google.firebase.auth.ListUsersPage;
import com.google.firebase.auth.OidcProviderConfig;
import com.google.firebase.auth.RevocationCheckDecorator;
import com.google.firebase.auth.SamlProviderConfig;
import com.google.firebase.auth.SessionCookieOptions;
import com.google.firebase.auth.UserIdentifier;
import com.google.firebase.auth.UserImportOptions;
import com.google.firebase.auth.UserImportResult;
import com.google.firebase.auth.UserRecord;
import com.google.firebase.auth.internal.FirebaseTokenFactory;
import com.google.firebase.internal.CallableOperation;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractFirebaseAuth {
    private final Object lock = new Object();
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final FirebaseApp firebaseApp;
    private final Supplier<FirebaseTokenFactory> tokenFactory;
    private final Supplier<? extends FirebaseTokenVerifier> idTokenVerifier;
    private final Supplier<? extends FirebaseTokenVerifier> cookieVerifier;
    private final Supplier<? extends FirebaseUserManager> userManager;
    private final JsonFactory jsonFactory;

    protected AbstractFirebaseAuth(Builder<?> builder) {
        this.firebaseApp = (FirebaseApp)Preconditions.checkNotNull((Object)((Builder)builder).firebaseApp);
        this.tokenFactory = this.threadSafeMemoize(((Builder)builder).tokenFactory);
        this.idTokenVerifier = this.threadSafeMemoize(((Builder)builder).idTokenVerifier);
        this.cookieVerifier = this.threadSafeMemoize(((Builder)builder).cookieVerifier);
        this.userManager = this.threadSafeMemoize(((Builder)builder).userManager);
        this.jsonFactory = this.firebaseApp.getOptions().getJsonFactory();
    }

    public String createCustomToken(@NonNull String uid) throws FirebaseAuthException {
        return this.createCustomToken(uid, null);
    }

    public String createCustomToken(@NonNull String uid, @Nullable Map<String, Object> developerClaims) throws FirebaseAuthException {
        return this.createCustomTokenOp(uid, developerClaims).call();
    }

    public ApiFuture<String> createCustomTokenAsync(@NonNull String uid) {
        return this.createCustomTokenAsync(uid, null);
    }

    public ApiFuture<String> createCustomTokenAsync(@NonNull String uid, @Nullable Map<String, Object> developerClaims) {
        return this.createCustomTokenOp(uid, developerClaims).callAsync(this.firebaseApp);
    }

    private CallableOperation<String, FirebaseAuthException> createCustomTokenOp(final String uid, final Map<String, Object> developerClaims) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        final FirebaseTokenFactory tokenFactory = (FirebaseTokenFactory)this.tokenFactory.get();
        return new CallableOperation<String, FirebaseAuthException>(){

            @Override
            public String execute() throws FirebaseAuthException {
                return tokenFactory.createSignedCustomAuthTokenForUser(uid, developerClaims);
            }
        };
    }

    public String createSessionCookie(@NonNull String idToken, @NonNull SessionCookieOptions options) throws FirebaseAuthException {
        return this.createSessionCookieOp(idToken, options).call();
    }

    public ApiFuture<String> createSessionCookieAsync(@NonNull String idToken, @NonNull SessionCookieOptions options) {
        return this.createSessionCookieOp(idToken, options).callAsync(this.firebaseApp);
    }

    private CallableOperation<String, FirebaseAuthException> createSessionCookieOp(final String idToken, final SessionCookieOptions options) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)idToken) ? 1 : 0) != 0, (Object)"idToken must not be null or empty");
        Preconditions.checkNotNull((Object)options, (Object)"options must not be null");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<String, FirebaseAuthException>(){

            @Override
            protected String execute() throws FirebaseAuthException {
                return userManager.createSessionCookie(idToken, options);
            }
        };
    }

    public FirebaseToken verifyIdToken(@NonNull String idToken) throws FirebaseAuthException {
        return this.verifyIdToken(idToken, false);
    }

    public FirebaseToken verifyIdToken(@NonNull String idToken, boolean checkRevoked) throws FirebaseAuthException {
        return this.verifyIdTokenOp(idToken, checkRevoked).call();
    }

    public ApiFuture<FirebaseToken> verifyIdTokenAsync(@NonNull String idToken) {
        return this.verifyIdTokenAsync(idToken, false);
    }

    public ApiFuture<FirebaseToken> verifyIdTokenAsync(@NonNull String idToken, boolean checkRevoked) {
        return this.verifyIdTokenOp(idToken, checkRevoked).callAsync(this.firebaseApp);
    }

    private CallableOperation<FirebaseToken, FirebaseAuthException> verifyIdTokenOp(final String idToken, boolean checkRevoked) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)idToken) ? 1 : 0) != 0, (Object)"ID token must not be null or empty");
        final FirebaseTokenVerifier verifier = this.getIdTokenVerifier(checkRevoked);
        return new CallableOperation<FirebaseToken, FirebaseAuthException>(){

            @Override
            protected FirebaseToken execute() throws FirebaseAuthException {
                return verifier.verifyToken(idToken);
            }
        };
    }

    @VisibleForTesting
    FirebaseTokenVerifier getIdTokenVerifier(boolean checkRevoked) {
        FirebaseTokenVerifier verifier = (FirebaseTokenVerifier)this.idTokenVerifier.get();
        if (checkRevoked) {
            FirebaseUserManager userManager = this.getUserManager();
            verifier = RevocationCheckDecorator.decorateIdTokenVerifier(verifier, userManager);
        }
        return verifier;
    }

    public FirebaseToken verifySessionCookie(String cookie) throws FirebaseAuthException {
        return this.verifySessionCookie(cookie, false);
    }

    public FirebaseToken verifySessionCookie(String cookie, boolean checkRevoked) throws FirebaseAuthException {
        return this.verifySessionCookieOp(cookie, checkRevoked).call();
    }

    public ApiFuture<FirebaseToken> verifySessionCookieAsync(String cookie) {
        return this.verifySessionCookieAsync(cookie, false);
    }

    public ApiFuture<FirebaseToken> verifySessionCookieAsync(String cookie, boolean checkRevoked) {
        return this.verifySessionCookieOp(cookie, checkRevoked).callAsync(this.firebaseApp);
    }

    private CallableOperation<FirebaseToken, FirebaseAuthException> verifySessionCookieOp(final String cookie, boolean checkRevoked) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cookie) ? 1 : 0) != 0, (Object)"Session cookie must not be null or empty");
        final FirebaseTokenVerifier sessionCookieVerifier = this.getSessionCookieVerifier(checkRevoked);
        return new CallableOperation<FirebaseToken, FirebaseAuthException>(){

            @Override
            public FirebaseToken execute() throws FirebaseAuthException {
                return sessionCookieVerifier.verifyToken(cookie);
            }
        };
    }

    @VisibleForTesting
    FirebaseTokenVerifier getSessionCookieVerifier(boolean checkRevoked) {
        FirebaseTokenVerifier verifier = (FirebaseTokenVerifier)this.cookieVerifier.get();
        if (checkRevoked) {
            FirebaseUserManager userManager = this.getUserManager();
            verifier = RevocationCheckDecorator.decorateSessionCookieVerifier(verifier, userManager);
        }
        return verifier;
    }

    public void revokeRefreshTokens(@NonNull String uid) throws FirebaseAuthException {
        this.revokeRefreshTokensOp(uid).call();
    }

    public ApiFuture<Void> revokeRefreshTokensAsync(@NonNull String uid) {
        return this.revokeRefreshTokensOp(uid).callAsync(this.firebaseApp);
    }

    private CallableOperation<Void, FirebaseAuthException> revokeRefreshTokensOp(final String uid) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<Void, FirebaseAuthException>(){

            @Override
            protected Void execute() throws FirebaseAuthException {
                int currentTimeSeconds = (int)(System.currentTimeMillis() / 1000L);
                UserRecord.UpdateRequest request = new UserRecord.UpdateRequest(uid).setValidSince(currentTimeSeconds);
                userManager.updateUser(request, AbstractFirebaseAuth.this.jsonFactory);
                return null;
            }
        };
    }

    public UserRecord getUser(@NonNull String uid) throws FirebaseAuthException {
        return this.getUserOp(uid).call();
    }

    public ApiFuture<UserRecord> getUserAsync(@NonNull String uid) {
        return this.getUserOp(uid).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserRecord, FirebaseAuthException> getUserOp(final String uid) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<UserRecord, FirebaseAuthException>(){

            @Override
            protected UserRecord execute() throws FirebaseAuthException {
                return userManager.getUserById(uid);
            }
        };
    }

    public UserRecord getUserByEmail(@NonNull String email) throws FirebaseAuthException {
        return this.getUserByEmailOp(email).call();
    }

    public ApiFuture<UserRecord> getUserByEmailAsync(@NonNull String email) {
        return this.getUserByEmailOp(email).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserRecord, FirebaseAuthException> getUserByEmailOp(final String email) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)email) ? 1 : 0) != 0, (Object)"email must not be null or empty");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<UserRecord, FirebaseAuthException>(){

            @Override
            protected UserRecord execute() throws FirebaseAuthException {
                return userManager.getUserByEmail(email);
            }
        };
    }

    public UserRecord getUserByPhoneNumber(@NonNull String phoneNumber) throws FirebaseAuthException {
        return this.getUserByPhoneNumberOp(phoneNumber).call();
    }

    public ApiFuture<UserRecord> getUserByPhoneNumberAsync(@NonNull String phoneNumber) {
        return this.getUserByPhoneNumberOp(phoneNumber).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserRecord, FirebaseAuthException> getUserByPhoneNumberOp(final String phoneNumber) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)phoneNumber) ? 1 : 0) != 0, (Object)"phone number must not be null or empty");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<UserRecord, FirebaseAuthException>(){

            @Override
            protected UserRecord execute() throws FirebaseAuthException {
                return userManager.getUserByPhoneNumber(phoneNumber);
            }
        };
    }

    public ListUsersPage listUsers(@Nullable String pageToken) throws FirebaseAuthException {
        return this.listUsers(pageToken, 1000);
    }

    public ListUsersPage listUsers(@Nullable String pageToken, int maxResults) throws FirebaseAuthException {
        return this.listUsersOp(pageToken, maxResults).call();
    }

    public ApiFuture<ListUsersPage> listUsersAsync(@Nullable String pageToken) {
        return this.listUsersAsync(pageToken, 1000);
    }

    public ApiFuture<ListUsersPage> listUsersAsync(@Nullable String pageToken, int maxResults) {
        return this.listUsersOp(pageToken, maxResults).callAsync(this.firebaseApp);
    }

    private CallableOperation<ListUsersPage, FirebaseAuthException> listUsersOp(@Nullable String pageToken, int maxResults) {
        FirebaseUserManager userManager = this.getUserManager();
        ListUsersPage.DefaultUserSource source = new ListUsersPage.DefaultUserSource(userManager, this.jsonFactory);
        final ListUsersPage.Factory factory = new ListUsersPage.Factory(source, maxResults, pageToken);
        return new CallableOperation<ListUsersPage, FirebaseAuthException>(){

            @Override
            protected ListUsersPage execute() throws FirebaseAuthException {
                return factory.create();
            }
        };
    }

    public UserRecord createUser(@NonNull UserRecord.CreateRequest request) throws FirebaseAuthException {
        return this.createUserOp(request).call();
    }

    public ApiFuture<UserRecord> createUserAsync(@NonNull UserRecord.CreateRequest request) {
        return this.createUserOp(request).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserRecord, FirebaseAuthException> createUserOp(final UserRecord.CreateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"create request must not be null");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<UserRecord, FirebaseAuthException>(){

            @Override
            protected UserRecord execute() throws FirebaseAuthException {
                String uid = userManager.createUser(request);
                return userManager.getUserById(uid);
            }
        };
    }

    public UserRecord updateUser(@NonNull UserRecord.UpdateRequest request) throws FirebaseAuthException {
        return this.updateUserOp(request).call();
    }

    public ApiFuture<UserRecord> updateUserAsync(@NonNull UserRecord.UpdateRequest request) {
        return this.updateUserOp(request).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserRecord, FirebaseAuthException> updateUserOp(final UserRecord.UpdateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"update request must not be null");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<UserRecord, FirebaseAuthException>(){

            @Override
            protected UserRecord execute() throws FirebaseAuthException {
                userManager.updateUser(request, AbstractFirebaseAuth.this.jsonFactory);
                return userManager.getUserById(request.getUid());
            }
        };
    }

    public void setCustomUserClaims(@NonNull String uid, @Nullable Map<String, Object> claims) throws FirebaseAuthException {
        this.setCustomUserClaimsOp(uid, claims).call();
    }

    public void setCustomClaims(@NonNull String uid, @Nullable Map<String, Object> claims) throws FirebaseAuthException {
        this.setCustomUserClaims(uid, claims);
    }

    public ApiFuture<Void> setCustomUserClaimsAsync(@NonNull String uid, @Nullable Map<String, Object> claims) {
        return this.setCustomUserClaimsOp(uid, claims).callAsync(this.firebaseApp);
    }

    private CallableOperation<Void, FirebaseAuthException> setCustomUserClaimsOp(final String uid, final Map<String, Object> claims) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<Void, FirebaseAuthException>(){

            @Override
            protected Void execute() throws FirebaseAuthException {
                UserRecord.UpdateRequest request = new UserRecord.UpdateRequest(uid).setCustomClaims(claims);
                userManager.updateUser(request, AbstractFirebaseAuth.this.jsonFactory);
                return null;
            }
        };
    }

    public void deleteUser(@NonNull String uid) throws FirebaseAuthException {
        this.deleteUserOp(uid).call();
    }

    public ApiFuture<Void> deleteUserAsync(String uid) {
        return this.deleteUserOp(uid).callAsync(this.firebaseApp);
    }

    private CallableOperation<Void, FirebaseAuthException> deleteUserOp(final String uid) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<Void, FirebaseAuthException>(){

            @Override
            protected Void execute() throws FirebaseAuthException {
                userManager.deleteUser(uid);
                return null;
            }
        };
    }

    public UserImportResult importUsers(List<ImportUserRecord> users) throws FirebaseAuthException {
        return this.importUsers(users, null);
    }

    public UserImportResult importUsers(List<ImportUserRecord> users, @Nullable UserImportOptions options) throws FirebaseAuthException {
        return this.importUsersOp(users, options).call();
    }

    public ApiFuture<UserImportResult> importUsersAsync(List<ImportUserRecord> users) {
        return this.importUsersAsync(users, null);
    }

    public ApiFuture<UserImportResult> importUsersAsync(List<ImportUserRecord> users, @Nullable UserImportOptions options) {
        return this.importUsersOp(users, options).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserImportResult, FirebaseAuthException> importUsersOp(List<ImportUserRecord> users, UserImportOptions options) {
        final FirebaseUserManager.UserImportRequest request = new FirebaseUserManager.UserImportRequest(users, options, this.jsonFactory);
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<UserImportResult, FirebaseAuthException>(){

            @Override
            protected UserImportResult execute() throws FirebaseAuthException {
                return userManager.importUsers(request);
            }
        };
    }

    public GetUsersResult getUsers(@NonNull Collection<UserIdentifier> identifiers) throws FirebaseAuthException {
        return this.getUsersOp(identifiers).call();
    }

    public ApiFuture<GetUsersResult> getUsersAsync(@NonNull Collection<UserIdentifier> identifiers) {
        return this.getUsersOp(identifiers).callAsync(this.firebaseApp);
    }

    private CallableOperation<GetUsersResult, FirebaseAuthException> getUsersOp(final @NonNull Collection<UserIdentifier> identifiers) {
        Preconditions.checkNotNull(identifiers, (Object)"identifiers must not be null");
        Preconditions.checkArgument((identifiers.size() <= 100 ? 1 : 0) != 0, (Object)"identifiers parameter must have <= 100 entries.");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<GetUsersResult, FirebaseAuthException>(){

            @Override
            protected GetUsersResult execute() throws FirebaseAuthException {
                Set<UserRecord> users = userManager.getAccountInfo(identifiers);
                HashSet<UserIdentifier> notFound = new HashSet<UserIdentifier>();
                for (UserIdentifier id : identifiers) {
                    if (AbstractFirebaseAuth.this.isUserFound(id, users)) continue;
                    notFound.add(id);
                }
                return new GetUsersResult(users, notFound);
            }
        };
    }

    private boolean isUserFound(UserIdentifier id, Collection<UserRecord> userRecords) {
        for (UserRecord userRecord : userRecords) {
            if (!id.matches(userRecord)) continue;
            return true;
        }
        return false;
    }

    public DeleteUsersResult deleteUsers(List<String> uids) throws FirebaseAuthException {
        return this.deleteUsersOp(uids).call();
    }

    public ApiFuture<DeleteUsersResult> deleteUsersAsync(List<String> uids) {
        return this.deleteUsersOp(uids).callAsync(this.firebaseApp);
    }

    private CallableOperation<DeleteUsersResult, FirebaseAuthException> deleteUsersOp(final List<String> uids) {
        Preconditions.checkNotNull(uids, (Object)"uids must not be null");
        for (String uid : uids) {
            UserRecord.checkUid(uid);
        }
        Preconditions.checkArgument((uids.size() <= 1000 ? 1 : 0) != 0, (Object)"uids parameter must have <= 1000 entries.");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<DeleteUsersResult, FirebaseAuthException>(){

            @Override
            protected DeleteUsersResult execute() throws FirebaseAuthException {
                return userManager.deleteUsers(uids);
            }
        };
    }

    public String generatePasswordResetLink(@NonNull String email) throws FirebaseAuthException {
        return this.generatePasswordResetLink(email, null);
    }

    public String generatePasswordResetLink(@NonNull String email, @Nullable ActionCodeSettings settings) throws FirebaseAuthException {
        return this.generateEmailActionLinkOp(FirebaseUserManager.EmailLinkType.PASSWORD_RESET, email, settings).call();
    }

    public ApiFuture<String> generatePasswordResetLinkAsync(@NonNull String email) {
        return this.generatePasswordResetLinkAsync(email, null);
    }

    public ApiFuture<String> generatePasswordResetLinkAsync(@NonNull String email, @Nullable ActionCodeSettings settings) {
        return this.generateEmailActionLinkOp(FirebaseUserManager.EmailLinkType.PASSWORD_RESET, email, settings).callAsync(this.firebaseApp);
    }

    public String generateEmailVerificationLink(@NonNull String email) throws FirebaseAuthException {
        return this.generateEmailVerificationLink(email, null);
    }

    public String generateEmailVerificationLink(@NonNull String email, @Nullable ActionCodeSettings settings) throws FirebaseAuthException {
        return this.generateEmailActionLinkOp(FirebaseUserManager.EmailLinkType.VERIFY_EMAIL, email, settings).call();
    }

    public ApiFuture<String> generateEmailVerificationLinkAsync(@NonNull String email) {
        return this.generateEmailVerificationLinkAsync(email, null);
    }

    public ApiFuture<String> generateEmailVerificationLinkAsync(@NonNull String email, @Nullable ActionCodeSettings settings) {
        return this.generateEmailActionLinkOp(FirebaseUserManager.EmailLinkType.VERIFY_EMAIL, email, settings).callAsync(this.firebaseApp);
    }

    public String generateSignInWithEmailLink(@NonNull String email, @NonNull ActionCodeSettings settings) throws FirebaseAuthException {
        return this.generateEmailActionLinkOp(FirebaseUserManager.EmailLinkType.EMAIL_SIGNIN, email, settings).call();
    }

    public ApiFuture<String> generateSignInWithEmailLinkAsync(String email, @NonNull ActionCodeSettings settings) {
        return this.generateEmailActionLinkOp(FirebaseUserManager.EmailLinkType.EMAIL_SIGNIN, email, settings).callAsync(this.firebaseApp);
    }

    private CallableOperation<String, FirebaseAuthException> generateEmailActionLinkOp(final FirebaseUserManager.EmailLinkType type, final String email, final ActionCodeSettings settings) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)email) ? 1 : 0) != 0, (Object)"email must not be null or empty");
        if (type == FirebaseUserManager.EmailLinkType.EMAIL_SIGNIN) {
            Preconditions.checkNotNull((Object)settings, (Object)"ActionCodeSettings must not be null when generating sign-in links");
        }
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<String, FirebaseAuthException>(){

            @Override
            protected String execute() throws FirebaseAuthException {
                return userManager.getEmailActionLink(type, email, settings);
            }
        };
    }

    public OidcProviderConfig createOidcProviderConfig(@NonNull OidcProviderConfig.CreateRequest request) throws FirebaseAuthException {
        return this.createOidcProviderConfigOp(request).call();
    }

    public ApiFuture<OidcProviderConfig> createOidcProviderConfigAsync(@NonNull OidcProviderConfig.CreateRequest request) {
        return this.createOidcProviderConfigOp(request).callAsync(this.firebaseApp);
    }

    private CallableOperation<OidcProviderConfig, FirebaseAuthException> createOidcProviderConfigOp(final OidcProviderConfig.CreateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"Create request must not be null.");
        OidcProviderConfig.checkOidcProviderId(request.getProviderId());
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<OidcProviderConfig, FirebaseAuthException>(){

            @Override
            protected OidcProviderConfig execute() throws FirebaseAuthException {
                return userManager.createOidcProviderConfig(request);
            }
        };
    }

    public OidcProviderConfig updateOidcProviderConfig(@NonNull OidcProviderConfig.UpdateRequest request) throws FirebaseAuthException {
        return this.updateOidcProviderConfigOp(request).call();
    }

    public ApiFuture<OidcProviderConfig> updateOidcProviderConfigAsync(@NonNull OidcProviderConfig.UpdateRequest request) {
        return this.updateOidcProviderConfigOp(request).callAsync(this.firebaseApp);
    }

    private CallableOperation<OidcProviderConfig, FirebaseAuthException> updateOidcProviderConfigOp(final OidcProviderConfig.UpdateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"Update request must not be null.");
        Preconditions.checkArgument((!request.getProperties().isEmpty() ? 1 : 0) != 0, (Object)"Update request must have at least one property set.");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<OidcProviderConfig, FirebaseAuthException>(){

            @Override
            protected OidcProviderConfig execute() throws FirebaseAuthException {
                return userManager.updateOidcProviderConfig(request);
            }
        };
    }

    public OidcProviderConfig getOidcProviderConfig(@NonNull String providerId) throws FirebaseAuthException {
        return this.getOidcProviderConfigOp(providerId).call();
    }

    public ApiFuture<OidcProviderConfig> getOidcProviderConfigAsync(@NonNull String providerId) {
        return this.getOidcProviderConfigOp(providerId).callAsync(this.firebaseApp);
    }

    private CallableOperation<OidcProviderConfig, FirebaseAuthException> getOidcProviderConfigOp(final String providerId) {
        OidcProviderConfig.checkOidcProviderId(providerId);
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<OidcProviderConfig, FirebaseAuthException>(){

            @Override
            protected OidcProviderConfig execute() throws FirebaseAuthException {
                return userManager.getOidcProviderConfig(providerId);
            }
        };
    }

    public ListProviderConfigsPage<OidcProviderConfig> listOidcProviderConfigs(@Nullable String pageToken) throws FirebaseAuthException {
        int maxResults = 100;
        return this.listOidcProviderConfigsOp(pageToken, maxResults).call();
    }

    public ListProviderConfigsPage<OidcProviderConfig> listOidcProviderConfigs(@Nullable String pageToken, int maxResults) throws FirebaseAuthException {
        return this.listOidcProviderConfigsOp(pageToken, maxResults).call();
    }

    public ApiFuture<ListProviderConfigsPage<OidcProviderConfig>> listOidcProviderConfigsAsync(@Nullable String pageToken) {
        int maxResults = 100;
        return this.listOidcProviderConfigsAsync(pageToken, maxResults);
    }

    public ApiFuture<ListProviderConfigsPage<OidcProviderConfig>> listOidcProviderConfigsAsync(@Nullable String pageToken, int maxResults) {
        return this.listOidcProviderConfigsOp(pageToken, maxResults).callAsync(this.firebaseApp);
    }

    private CallableOperation<ListProviderConfigsPage<OidcProviderConfig>, FirebaseAuthException> listOidcProviderConfigsOp(@Nullable String pageToken, int maxResults) {
        FirebaseUserManager userManager = this.getUserManager();
        ListProviderConfigsPage.DefaultOidcProviderConfigSource source = new ListProviderConfigsPage.DefaultOidcProviderConfigSource(userManager);
        final ListProviderConfigsPage.Factory<OidcProviderConfig> factory = new ListProviderConfigsPage.Factory<OidcProviderConfig>(source, maxResults, pageToken);
        return new CallableOperation<ListProviderConfigsPage<OidcProviderConfig>, FirebaseAuthException>(){

            @Override
            protected ListProviderConfigsPage<OidcProviderConfig> execute() throws FirebaseAuthException {
                return factory.create();
            }
        };
    }

    public void deleteOidcProviderConfig(@NonNull String providerId) throws FirebaseAuthException {
        this.deleteOidcProviderConfigOp(providerId).call();
    }

    public ApiFuture<Void> deleteOidcProviderConfigAsync(String providerId) {
        return this.deleteOidcProviderConfigOp(providerId).callAsync(this.firebaseApp);
    }

    private CallableOperation<Void, FirebaseAuthException> deleteOidcProviderConfigOp(final String providerId) {
        OidcProviderConfig.checkOidcProviderId(providerId);
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<Void, FirebaseAuthException>(){

            @Override
            protected Void execute() throws FirebaseAuthException {
                userManager.deleteOidcProviderConfig(providerId);
                return null;
            }
        };
    }

    public SamlProviderConfig createSamlProviderConfig(@NonNull SamlProviderConfig.CreateRequest request) throws FirebaseAuthException {
        return this.createSamlProviderConfigOp(request).call();
    }

    public ApiFuture<SamlProviderConfig> createSamlProviderConfigAsync(@NonNull SamlProviderConfig.CreateRequest request) {
        return this.createSamlProviderConfigOp(request).callAsync(this.firebaseApp);
    }

    private CallableOperation<SamlProviderConfig, FirebaseAuthException> createSamlProviderConfigOp(final SamlProviderConfig.CreateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"Create request must not be null.");
        SamlProviderConfig.checkSamlProviderId(request.getProviderId());
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<SamlProviderConfig, FirebaseAuthException>(){

            @Override
            protected SamlProviderConfig execute() throws FirebaseAuthException {
                return userManager.createSamlProviderConfig(request);
            }
        };
    }

    public SamlProviderConfig updateSamlProviderConfig(@NonNull SamlProviderConfig.UpdateRequest request) throws FirebaseAuthException {
        return this.updateSamlProviderConfigOp(request).call();
    }

    public ApiFuture<SamlProviderConfig> updateSamlProviderConfigAsync(@NonNull SamlProviderConfig.UpdateRequest request) {
        return this.updateSamlProviderConfigOp(request).callAsync(this.firebaseApp);
    }

    private CallableOperation<SamlProviderConfig, FirebaseAuthException> updateSamlProviderConfigOp(final SamlProviderConfig.UpdateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"Update request must not be null.");
        Preconditions.checkArgument((!request.getProperties().isEmpty() ? 1 : 0) != 0, (Object)"Update request must have at least one property set.");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<SamlProviderConfig, FirebaseAuthException>(){

            @Override
            protected SamlProviderConfig execute() throws FirebaseAuthException {
                return userManager.updateSamlProviderConfig(request);
            }
        };
    }

    public SamlProviderConfig getSamlProviderConfig(@NonNull String providerId) throws FirebaseAuthException {
        return this.getSamlProviderConfigOp(providerId).call();
    }

    public ApiFuture<SamlProviderConfig> getSamlProviderConfigAsync(@NonNull String providerId) {
        return this.getSamlProviderConfigOp(providerId).callAsync(this.firebaseApp);
    }

    private CallableOperation<SamlProviderConfig, FirebaseAuthException> getSamlProviderConfigOp(final String providerId) {
        SamlProviderConfig.checkSamlProviderId(providerId);
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<SamlProviderConfig, FirebaseAuthException>(){

            @Override
            protected SamlProviderConfig execute() throws FirebaseAuthException {
                return userManager.getSamlProviderConfig(providerId);
            }
        };
    }

    public ListProviderConfigsPage<SamlProviderConfig> listSamlProviderConfigs(@Nullable String pageToken) throws FirebaseAuthException {
        return this.listSamlProviderConfigs(pageToken, 100);
    }

    public ListProviderConfigsPage<SamlProviderConfig> listSamlProviderConfigs(@Nullable String pageToken, int maxResults) throws FirebaseAuthException {
        return this.listSamlProviderConfigsOp(pageToken, maxResults).call();
    }

    public ApiFuture<ListProviderConfigsPage<SamlProviderConfig>> listSamlProviderConfigsAsync(@Nullable String pageToken) {
        int maxResults = 100;
        return this.listSamlProviderConfigsAsync(pageToken, maxResults);
    }

    public ApiFuture<ListProviderConfigsPage<SamlProviderConfig>> listSamlProviderConfigsAsync(@Nullable String pageToken, int maxResults) {
        return this.listSamlProviderConfigsOp(pageToken, maxResults).callAsync(this.firebaseApp);
    }

    private CallableOperation<ListProviderConfigsPage<SamlProviderConfig>, FirebaseAuthException> listSamlProviderConfigsOp(@Nullable String pageToken, int maxResults) {
        FirebaseUserManager userManager = this.getUserManager();
        ListProviderConfigsPage.DefaultSamlProviderConfigSource source = new ListProviderConfigsPage.DefaultSamlProviderConfigSource(userManager);
        final ListProviderConfigsPage.Factory<SamlProviderConfig> factory = new ListProviderConfigsPage.Factory<SamlProviderConfig>(source, maxResults, pageToken);
        return new CallableOperation<ListProviderConfigsPage<SamlProviderConfig>, FirebaseAuthException>(){

            @Override
            protected ListProviderConfigsPage<SamlProviderConfig> execute() throws FirebaseAuthException {
                return factory.create();
            }
        };
    }

    public void deleteSamlProviderConfig(@NonNull String providerId) throws FirebaseAuthException {
        this.deleteSamlProviderConfigOp(providerId).call();
    }

    public ApiFuture<Void> deleteSamlProviderConfigAsync(String providerId) {
        return this.deleteSamlProviderConfigOp(providerId).callAsync(this.firebaseApp);
    }

    private CallableOperation<Void, FirebaseAuthException> deleteSamlProviderConfigOp(final String providerId) {
        SamlProviderConfig.checkSamlProviderId(providerId);
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<Void, FirebaseAuthException>(){

            @Override
            protected Void execute() throws FirebaseAuthException {
                userManager.deleteSamlProviderConfig(providerId);
                return null;
            }
        };
    }

    FirebaseUserManager getUserManager() {
        return (FirebaseUserManager)this.userManager.get();
    }

    <T> Supplier<T> threadSafeMemoize(final Supplier<T> supplier) {
        return Suppliers.memoize((Supplier)new Supplier<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T get() {
                Preconditions.checkNotNull((Object)supplier);
                Object object = AbstractFirebaseAuth.this.lock;
                synchronized (object) {
                    return supplier.get();
                }
            }
        });
    }

    protected static <T extends Builder<T>> T populateBuilderFromApp(Builder<T> builder, final FirebaseApp app, final @Nullable String tenantId) {
        return ((Builder)((Builder)((Builder)((Builder)builder.setFirebaseApp(app)).setTokenFactory(new Supplier<FirebaseTokenFactory>(){

            public FirebaseTokenFactory get() {
                return FirebaseTokenUtils.createTokenFactory(app, Clock.SYSTEM, tenantId);
            }
        })).setIdTokenVerifier((Supplier<FirebaseTokenVerifier>)new Supplier<FirebaseTokenVerifier>(){

            public FirebaseTokenVerifier get() {
                return FirebaseTokenUtils.createIdTokenVerifier(app, Clock.SYSTEM, tenantId);
            }
        })).setCookieVerifier((Supplier<FirebaseTokenVerifier>)new Supplier<FirebaseTokenVerifier>(){

            public FirebaseTokenVerifier get() {
                return FirebaseTokenUtils.createSessionCookieVerifier(app, Clock.SYSTEM, tenantId);
            }
        })).setUserManager(new Supplier<FirebaseUserManager>(){

            public FirebaseUserManager get() {
                return FirebaseUserManager.createUserManager(app, tenantId);
            }
        });
    }

    protected static abstract class Builder<T extends Builder<T>> {
        private FirebaseApp firebaseApp;
        private Supplier<FirebaseTokenFactory> tokenFactory;
        private Supplier<? extends FirebaseTokenVerifier> idTokenVerifier;
        private Supplier<? extends FirebaseTokenVerifier> cookieVerifier;
        private Supplier<? extends FirebaseUserManager> userManager;

        protected Builder() {
        }

        protected abstract T getThis();

        public FirebaseApp getFirebaseApp() {
            return this.firebaseApp;
        }

        public T setFirebaseApp(FirebaseApp firebaseApp) {
            this.firebaseApp = firebaseApp;
            return this.getThis();
        }

        public T setIdTokenVerifier(Supplier<? extends FirebaseTokenVerifier> idTokenVerifier) {
            this.idTokenVerifier = idTokenVerifier;
            return this.getThis();
        }

        public T setCookieVerifier(Supplier<? extends FirebaseTokenVerifier> cookieVerifier) {
            this.cookieVerifier = cookieVerifier;
            return this.getThis();
        }

        T setUserManager(Supplier<FirebaseUserManager> userManager) {
            this.userManager = userManager;
            return this.getThis();
        }

        T setTokenFactory(Supplier<FirebaseTokenFactory> tokenFactory) {
            this.tokenFactory = tokenFactory;
            return this.getThis();
        }
    }
}

