/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.rbac;

import java.util.ArrayList;
import java.util.List;

class Role {
    String name;
    private List<Role> roles;

    protected Role(String name) {
        this.name = name;
        this.roles = new ArrayList<Role>();
    }

    void addRole(Role role) {
        for (Role r : this.roles) {
            if (!r.name.equals(role.name)) continue;
            return;
        }
        this.roles.add(role);
    }

    void deleteRole(Role role) {
        for (Role r : this.roles) {
            if (!r.name.equals(role.name)) continue;
            this.roles.remove(r);
        }
    }

    boolean hasRole(String name, int hierarchyLevel) {
        if (this.name.equals(name)) {
            return true;
        }
        if (hierarchyLevel <= 0) {
            return false;
        }
        for (Role role : this.roles) {
            if (!role.hasRole(name, hierarchyLevel - 1)) continue;
            return true;
        }
        return false;
    }

    boolean hasDirectRole(String name) {
        for (Role r : this.roles) {
            if (!r.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder names = new StringBuilder();
        for (int i = 0; i < this.roles.size(); ++i) {
            Role role = this.roles.get(i);
            if (i == 0) {
                names.append(role.name);
                continue;
            }
            names.append(", " + role.name);
        }
        return this.name + " < " + names;
    }

    List<String> getRoles() {
        ArrayList<String> names = new ArrayList<String>();
        for (Role r : this.roles) {
            names.add(r.name);
        }
        return names;
    }
}

