/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import com.zaxxer.hikari.metrics.micrometer.MicrometerMetricsTrackerFactory;
import io.micrometer.core.instrument.MeterRegistry;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.jdbc.DataSourceUnwrapper;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;

class HikariDataSourceMetricsPostProcessor
implements BeanPostProcessor,
Ordered {
    private static final Log logger = LogFactory.getLog(HikariDataSourceMetricsPostProcessor.class);
    private final ApplicationContext context;
    private volatile MeterRegistry meterRegistry;

    HikariDataSourceMetricsPostProcessor(ApplicationContext context) {
        this.context = context;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        HikariDataSource hikariDataSource = this.determineHikariDataSource(bean);
        if (hikariDataSource != null) {
            this.bindMetricsRegistryToHikariDataSource(this.getMeterRegistry(), hikariDataSource);
        }
        return bean;
    }

    private HikariDataSource determineHikariDataSource(Object bean) {
        if (bean instanceof DataSource) {
            return (HikariDataSource)DataSourceUnwrapper.unwrap((DataSource)((DataSource)bean), HikariDataSource.class);
        }
        return null;
    }

    private void bindMetricsRegistryToHikariDataSource(MeterRegistry registry, HikariDataSource dataSource) {
        if (!this.hasExisingMetrics(dataSource)) {
            try {
                dataSource.setMetricsTrackerFactory((MetricsTrackerFactory)new MicrometerMetricsTrackerFactory(registry));
            }
            catch (Exception ex) {
                logger.warn((Object)("Failed to bind Hikari metrics: " + ex.getMessage()));
            }
        }
    }

    private boolean hasExisingMetrics(HikariDataSource dataSource) {
        return dataSource.getMetricRegistry() != null || dataSource.getMetricsTrackerFactory() != null;
    }

    private MeterRegistry getMeterRegistry() {
        if (this.meterRegistry == null) {
            this.meterRegistry = (MeterRegistry)this.context.getBean(MeterRegistry.class);
        }
        return this.meterRegistry;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

