/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.AddressValueException;
import inet.ipaddr.format.AddressDivision;
import inet.ipaddr.format.IPAddressDivision;

public abstract class IPAddressJoinedSegments
extends IPAddressDivision {
    private static final long serialVersionUID = 4L;
    protected final int joinedCount;
    protected final long value;
    protected final long upperValue;

    public IPAddressJoinedSegments(int joinedCount, int value) {
        if (value < 0) {
            throw new AddressValueException(value);
        }
        if (joinedCount <= 0) {
            throw new AddressValueException(joinedCount);
        }
        this.value = this.upperValue = (long)value;
        this.joinedCount = joinedCount;
    }

    public IPAddressJoinedSegments(int joinedCount, long value, Integer segmentPrefixLength) {
        this(joinedCount, value, value, segmentPrefixLength);
    }

    public IPAddressJoinedSegments(int joinedCount, long lower, long upper, Integer segmentPrefixLength) {
        super(segmentPrefixLength);
        if (lower < 0L || upper < 0L) {
            throw new AddressValueException(lower < 0L ? lower : upper);
        }
        if (joinedCount <= 0) {
            throw new AddressValueException(joinedCount);
        }
        if (lower > upper) {
            long tmp = lower;
            lower = upper;
            upper = tmp;
        }
        this.value = lower;
        this.upperValue = upper;
        this.joinedCount = joinedCount;
    }

    public int getJoinedCount() {
        return this.joinedCount;
    }

    @Override
    public long getLowerValue() {
        return this.value;
    }

    @Override
    public long getUpperValue() {
        return this.upperValue;
    }

    protected abstract int getBitsPerSegment();

    @Override
    public int getBitCount() {
        return (this.joinedCount + 1) * this.getBitsPerSegment();
    }

    @Override
    public int getMaxDigitCount() {
        return IPAddressJoinedSegments.getDigitCount(this.getMaxValue(), this.getDefaultTextualRadix());
    }

    @Override
    protected boolean isSameValues(AddressDivision other) {
        return other instanceof IPAddressJoinedSegments && this.isSameValues((IPAddressJoinedSegments)other);
    }

    protected boolean isSameValues(IPAddressJoinedSegments otherSegment) {
        return otherSegment.joinedCount == this.joinedCount && this.value == otherSegment.value && this.upperValue == otherSegment.upperValue;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof IPAddressJoinedSegments && this.isSameValues((IPAddressJoinedSegments)other);
    }

    public int hashCode() {
        return (int)(this.value | this.upperValue << this.getBitCount());
    }
}

