/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.Address;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.format.validate.ParsedAddressCreator;
import inet.ipaddr.format.validate.ParsedHostIdentifierStringQualifier;
import inet.ipaddr.format.validate.ParsedIPAddress;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Objects;

public abstract class IPAddressProvider
implements Serializable,
Comparable<IPAddressProvider> {
    private static final long serialVersionUID = 4L;
    public static final NullProvider INVALID_PROVIDER = new NullProvider(IPType.INVALID){

        @Override
        public boolean isInvalid() {
            return true;
        }
    };
    public static final NullProvider NO_TYPE_PROVIDER = new NullProvider(null){

        @Override
        public boolean isUninitialized() {
            return true;
        }
    };
    static final NullProvider EMPTY_PROVIDER = new NullProvider(IPType.EMPTY){

        @Override
        public boolean isEmpty() {
            return true;
        }
    };

    private IPAddressProvider() {
    }

    public abstract IPType getType();

    public abstract IPAddress getHostAddress();

    public abstract IPAddress getAddress();

    public abstract IPAddress getAddress(IPAddress.IPVersion var1);

    public int hashCode() {
        IPAddress value = this.getAddress();
        if (value != null) {
            return value.hashCode();
        }
        return Objects.hashCode((Object)this.getType());
    }

    @Override
    public int compareTo(IPAddressProvider other) {
        IPAddress otherValue;
        if (this == other) {
            return 0;
        }
        IPAddress value = this.getAddress();
        if (value != null && (otherValue = other.getAddress()) != null) {
            return value.compareTo(otherValue);
        }
        IPType thisType = this.getType();
        IPType otherType = other.getType();
        if (thisType == null) {
            return otherType == null ? 0 : -1;
        }
        if (otherType == null) {
            return 1;
        }
        return thisType.ordinal() - otherType.ordinal();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IPAddressProvider) {
            IPAddress otherValue;
            IPAddressProvider other = (IPAddressProvider)o;
            IPAddress value = this.getAddress();
            if (value != null && (otherValue = other.getAddress()) != null) {
                return value.equals(otherValue);
            }
            return this.getType() == other.getType();
        }
        return false;
    }

    public IPAddress.IPVersion getIPVersion() {
        return null;
    }

    public boolean isIPAddress() {
        return false;
    }

    public boolean isIPv4() {
        return false;
    }

    public boolean isIPv6() {
        return false;
    }

    public boolean isPrefixOnly() {
        return false;
    }

    public boolean isAllAddresses() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isInvalid() {
        return false;
    }

    public boolean isUninitialized() {
        return false;
    }

    public boolean isMixedIPv6() {
        return false;
    }

    public boolean isBase85IPv6() {
        return false;
    }

    public Integer getNetworkPrefixLength() {
        return null;
    }

    public boolean isPrefixed() {
        return this.getNetworkPrefixLength() != null;
    }

    public IPAddressStringParameters getParameters() {
        return null;
    }

    public String toString() {
        return String.valueOf(this.getAddress());
    }

    public static IPAddressProvider getProviderFor(IPAddress address, IPAddress hostAddress) {
        return new CachedAddressProvider(address, hostAddress);
    }

    /* synthetic */ IPAddressProvider(IPAddressProvider iPAddressProvider) {
        this();
    }

    private static abstract class AdjustedAddressCreator
    extends VersionedAddressCreator {
        private static final long serialVersionUID = 4L;
        protected final IPAddress.IPVersion adjustedVersion;
        protected final ParsedHostIdentifierStringQualifier qualifier;

        AdjustedAddressCreator(ParsedHostIdentifierStringQualifier qualifier, IPAddressStringParameters options) {
            this(qualifier, null, options);
        }

        AdjustedAddressCreator(ParsedHostIdentifierStringQualifier qualifier, IPAddress.IPVersion adjustedVersion, IPAddressStringParameters options) {
            super(options);
            this.qualifier = qualifier;
            this.adjustedVersion = adjustedVersion;
        }

        @Override
        public boolean isIPAddress() {
            return this.adjustedVersion != null;
        }

        @Override
        public boolean isIPv4() {
            return this.isIPAddress() && this.adjustedVersion.isIPv4();
        }

        @Override
        public boolean isIPv6() {
            return this.isIPAddress() && this.adjustedVersion.isIPv6();
        }

        @Override
        public IPAddress.IPVersion getIPVersion() {
            return this.adjustedVersion;
        }

        @Override
        public Integer getNetworkPrefixLength() {
            if (this.qualifier == null) {
                return null;
            }
            return this.qualifier.getNetworkPrefixLength();
        }

        @Override
        public IPAddress getAddress() {
            if (this.adjustedVersion == null) {
                return null;
            }
            return super.getAddress();
        }

        @Override
        public IPAddress getHostAddress() {
            if (this.adjustedVersion == null) {
                return null;
            }
            return super.getHostAddress();
        }
    }

    static class AllCreator
    extends AdjustedAddressCreator {
        private static final long serialVersionUID = 4L;
        HostIdentifierString originator;

        AllCreator(ParsedHostIdentifierStringQualifier qualifier, HostIdentifierString originator, IPAddressStringParameters options) {
            super(qualifier, options);
            this.originator = originator;
        }

        AllCreator(ParsedHostIdentifierStringQualifier qualifier, IPAddress.IPVersion adjustedVersion, HostIdentifierString originator, IPAddressStringParameters options) {
            super(qualifier, adjustedVersion, options);
            this.originator = originator;
        }

        @Override
        IPAddress createVersionedAddress(IPAddress.IPVersion version) {
            return ParsedIPAddress.createAllAddress(version, this.qualifier, this.originator, this.options);
        }

        @Override
        public IPType getType() {
            if (this.adjustedVersion != null) {
                return IPType.from(this.adjustedVersion);
            }
            return IPType.ALL;
        }

        @Override
        public boolean isAllAddresses() {
            return this.adjustedVersion == null;
        }

        @Override
        public int hashCode() {
            if (this.adjustedVersion == null) {
                return IPAddress.SEGMENT_WILDCARD_STR.hashCode();
            }
            return super.hashCode();
        }

        @Override
        ParsedIPAddress.CachedIPAddresses<?> createAddresses() {
            return new ParsedIPAddress.CachedIPAddresses<IPAddress>(ParsedIPAddress.createAllAddress(this.adjustedVersion, this.qualifier, this.originator, this.options));
        }
    }

    private static abstract class CachedAddressCreator
    extends CachedAddressProvider {
        private static final long serialVersionUID = 4L;

        private CachedAddressCreator() {
        }

        @Override
        public IPAddress getAddress(IPAddress.IPVersion version) {
            this.getAddress();
            return super.getAddress(version);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ParsedIPAddress.CachedIPAddresses<?> getCachedAddresses() {
            ParsedIPAddress.CachedIPAddresses<?> val = this.values;
            if (val == null) {
                CachedAddressCreator cachedAddressCreator = this;
                synchronized (cachedAddressCreator) {
                    val = this.values;
                    if (val == null) {
                        this.values = val = this.createAddresses();
                    }
                }
            }
            return val;
        }

        @Override
        public IPAddress getHostAddress() {
            return this.getCachedAddresses().getHostAddress();
        }

        @Override
        public IPAddress getAddress() {
            return this.getCachedAddresses().getAddress();
        }

        @Override
        public Integer getNetworkPrefixLength() {
            this.getAddress();
            return super.getNetworkPrefixLength();
        }

        abstract ParsedIPAddress.CachedIPAddresses<?> createAddresses();
    }

    private static class CachedAddressProvider
    extends IPAddressProvider {
        private static final long serialVersionUID = 4L;
        ParsedIPAddress.CachedIPAddresses<?> values;

        CachedAddressProvider() {
            super(null);
        }

        private CachedAddressProvider(IPAddress address, IPAddress hostAddress) {
            super(null);
            this.values = new ParsedIPAddress.CachedIPAddresses<IPAddress>(address, hostAddress);
        }

        @Override
        public IPAddress.IPVersion getIPVersion() {
            return this.getAddress().getIPVersion();
        }

        @Override
        public IPType getType() {
            return IPType.from(this.getIPVersion());
        }

        @Override
        public boolean isIPAddress() {
            return true;
        }

        @Override
        public boolean isIPv4() {
            return this.getAddress().isIPv4();
        }

        @Override
        public boolean isIPv6() {
            return this.getAddress().isIPv6();
        }

        @Override
        public IPAddress getHostAddress() {
            return this.values.getHostAddress();
        }

        @Override
        public IPAddress getAddress() {
            return this.values.getAddress();
        }

        @Override
        public Integer getNetworkPrefixLength() {
            return this.getAddress().getNetworkPrefixLength();
        }

        @Override
        public IPAddress getAddress(IPAddress.IPVersion version) {
            IPAddress.IPVersion thisVersion = this.getIPVersion();
            if (!version.equals((Object)thisVersion)) {
                return null;
            }
            return this.getAddress();
        }
    }

    private static enum IPType {
        INVALID,
        EMPTY,
        IPV4,
        IPV6,
        PREFIX_ONLY,
        ALL;


        static IPType from(IPAddress.IPVersion version) {
            switch (version) {
                case IPV4: {
                    return IPV4;
                }
                case IPV6: {
                    return IPV6;
                }
            }
            return null;
        }
    }

    static class LoopbackCreator
    extends VersionedAddressCreator {
        private static final long serialVersionUID = 4L;
        private final CharSequence zone;

        LoopbackCreator(IPAddressStringParameters options) {
            this(null, options);
        }

        LoopbackCreator(CharSequence zone, IPAddressStringParameters options) {
            super(options);
            this.zone = zone;
        }

        @Override
        public IPType getType() {
            return IPType.from(this.getIPVersion());
        }

        @Override
        public boolean isIPAddress() {
            return true;
        }

        @Override
        public boolean isIPv4() {
            return this.getAddress().isIPv4();
        }

        @Override
        public boolean isIPv6() {
            return this.getAddress().isIPv6();
        }

        @Override
        IPAddress createVersionedAddress(IPAddress.IPVersion version) {
            if (this.values != null && version.equals((Object)((IPAddress)this.values.getAddress()).getIPVersion())) {
                return this.values.getAddress();
            }
            IPAddressNetwork network = version.isIPv4() ? this.options.getIPv4Parameters().getNetwork() : this.options.getIPv6Parameters().getNetwork();
            Object address = network.getLoopback();
            if (this.zone != null && this.zone.length() > 0 && version.isIPv6()) {
                IPAddressNetwork.IPAddressCreator addressCreator = network.getAddressCreator();
                return (IPAddress)((ParsedAddressCreator)addressCreator).createAddressInternal(((Address)address).getBytes(), this.zone);
            }
            return address;
        }

        ParsedIPAddress.CachedIPAddresses<IPAddress> createAddresses() {
            Object result;
            InetAddress loopback = InetAddress.getLoopbackAddress();
            boolean isIPv6 = loopback instanceof Inet6Address;
            if (this.zone != null && this.zone.length() > 0 && isIPv6) {
                IPv6AddressNetwork.IPv6AddressCreator addressCreator = this.options.getIPv6Parameters().getNetwork().getAddressCreator();
                result = (IPAddress)((ParsedAddressCreator)addressCreator).createAddressInternal(loopback.getAddress(), this.zone);
            } else {
                result = isIPv6 ? this.options.getIPv6Parameters().getNetwork().getLoopback() : this.options.getIPv4Parameters().getNetwork().getLoopback();
            }
            return new ParsedIPAddress.CachedIPAddresses<IPAddress>((IPAddress)result);
        }

        @Override
        public IPAddress.IPVersion getIPVersion() {
            return this.getAddress().getIPVersion();
        }

        @Override
        public Integer getNetworkPrefixLength() {
            return null;
        }
    }

    static class MaskCreator
    extends AdjustedAddressCreator {
        private static final long serialVersionUID = 4L;

        MaskCreator(ParsedHostIdentifierStringQualifier qualifier, IPAddressStringParameters options) {
            super(qualifier, options);
        }

        MaskCreator(ParsedHostIdentifierStringQualifier qualifier, IPAddress.IPVersion adjustedVersion, IPAddressStringParameters options) {
            super(qualifier, adjustedVersion, options);
        }

        @Override
        public int hashCode() {
            if (this.adjustedVersion == null) {
                return this.getNetworkPrefixLength();
            }
            return this.getAddress().hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof IPAddressProvider) {
                IPAddressProvider valueProvider = (IPAddressProvider)o;
                if (this.adjustedVersion == null) {
                    if (valueProvider.getType() == IPType.PREFIX_ONLY) {
                        return valueProvider.getNetworkPrefixLength() == this.getNetworkPrefixLength();
                    }
                    return false;
                }
                return super.equals(valueProvider);
            }
            return false;
        }

        @Override
        public int compareTo(IPAddressProvider other) {
            if (this == other) {
                return 0;
            }
            if (this.adjustedVersion == null) {
                if (other.getType() == IPType.PREFIX_ONLY) {
                    return other.getNetworkPrefixLength() - this.getNetworkPrefixLength();
                }
                return IPType.PREFIX_ONLY.ordinal() - other.getType().ordinal();
            }
            IPAddress otherValue = other.getAddress();
            if (otherValue != null) {
                return this.getAddress().compareTo(otherValue);
            }
            return IPType.from(this.adjustedVersion).ordinal() - other.getType().ordinal();
        }

        private IPAddress createVersionedMask(IPAddress.IPVersion version, int bits, boolean withPrefixLength) {
            IPAddressNetwork network = version.isIPv4() ? this.options.getIPv4Parameters().getNetwork() : this.options.getIPv6Parameters().getNetwork();
            return network.getNetworkMask(bits, withPrefixLength);
        }

        @Override
        IPAddress createVersionedAddress(IPAddress.IPVersion version) {
            return this.createVersionedMask(version, this.getNetworkPrefixLength(), true);
        }

        @Override
        public Integer getNetworkPrefixLength() {
            return this.qualifier.getNetworkPrefixLength();
        }

        @Override
        public IPType getType() {
            if (this.adjustedVersion != null) {
                return IPType.from(this.adjustedVersion);
            }
            return IPType.PREFIX_ONLY;
        }

        @Override
        public boolean isPrefixOnly() {
            return this.adjustedVersion == null;
        }

        @Override
        ParsedIPAddress.CachedIPAddresses<?> createAddresses() {
            return new ParsedIPAddress.CachedIPAddresses<IPAddress>(this.createVersionedMask(this.adjustedVersion, this.getNetworkPrefixLength(), true), this.createVersionedMask(this.adjustedVersion, this.getNetworkPrefixLength(), false));
        }
    }

    private static abstract class NullProvider
    extends IPAddressProvider {
        private static final long serialVersionUID = 4L;
        private IPType type;

        public NullProvider(IPType type) {
            super(null);
            this.type = type;
        }

        @Override
        public IPType getType() {
            return this.type;
        }

        @Override
        public IPAddress getHostAddress() {
            return null;
        }

        @Override
        public IPAddress getAddress() {
            return null;
        }

        @Override
        public IPAddress getAddress(IPAddress.IPVersion version) {
            return null;
        }
    }

    static class ParsedAddressProvider
    extends CachedAddressCreator {
        private static final long serialVersionUID = 4L;
        private ParsedIPAddress parseResult;
        private IPAddress.IPVersion version;
        boolean isMixedIPv6;
        boolean isBase85IPv6;

        ParsedAddressProvider(ParsedIPAddress parseResult) {
            this.parseResult = parseResult;
            this.version = parseResult.getIPVersion();
            this.isMixedIPv6 = parseResult.isMixedIPv6();
            this.isBase85IPv6 = parseResult.isBase85IPv6();
        }

        @Override
        public boolean isMixedIPv6() {
            return this.isMixedIPv6;
        }

        @Override
        public boolean isBase85IPv6() {
            return this.isBase85IPv6;
        }

        @Override
        public IPAddress.IPVersion getIPVersion() {
            return this.version;
        }

        @Override
        public boolean isIPv4() {
            return this.getIPVersion().isIPv4();
        }

        @Override
        public boolean isIPv6() {
            return this.getIPVersion().isIPv6();
        }

        ParsedIPAddress.IPAddresses<?, ?> createAddresses() {
            ParsedIPAddress.IPAddresses<?, ?> result = this.parseResult.createAddresses();
            this.parseResult = null;
            return result;
        }

        @Override
        public Integer getNetworkPrefixLength() {
            ParsedIPAddress parsedAddress = this.parseResult;
            if (parsedAddress != null) {
                return parsedAddress.getNetworkPrefixLength();
            }
            return super.getNetworkPrefixLength();
        }

        @Override
        public boolean isPrefixed() {
            ParsedIPAddress parsedAddress = this.parseResult;
            if (parsedAddress != null) {
                return parsedAddress.isPrefixed();
            }
            return super.isPrefixed();
        }

        @Override
        public IPAddressStringParameters getParameters() {
            return this.parseResult.options;
        }
    }

    static abstract class VersionedAddressCreator
    extends CachedAddressCreator {
        private static final long serialVersionUID = 4L;
        IPAddress[] versionedValues;
        protected final IPAddressStringParameters options;

        VersionedAddressCreator(IPAddressStringParameters options) {
            this.options = options;
        }

        @Override
        public IPAddressStringParameters getParameters() {
            return this.options;
        }

        private IPAddress checkResult(IPAddress.IPVersion version, int index) {
            IPAddress result = this.versionedValues[index];
            if (result == null) {
                this.versionedValues[index] = result = this.createVersionedAddress(version);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IPAddress getAddress(IPAddress.IPVersion version) {
            IPAddress result;
            int index = version.ordinal();
            if (this.versionedValues == null) {
                VersionedAddressCreator versionedAddressCreator = this;
                synchronized (versionedAddressCreator) {
                    if (this.versionedValues == null) {
                        this.versionedValues = new IPAddress[IPAddress.IPVersion.values().length];
                        this.versionedValues[index] = result = this.createVersionedAddress(version);
                    } else {
                        result = this.checkResult(version, index);
                    }
                }
            }
            result = this.versionedValues[index];
            if (result == null) {
                VersionedAddressCreator versionedAddressCreator = this;
                synchronized (versionedAddressCreator) {
                    result = this.checkResult(version, index);
                }
            }
            return result;
        }

        abstract IPAddress createVersionedAddress(IPAddress.IPVersion var1);
    }
}

