/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import io.searchbox.client.JestResult;

public class UpdateByQueryResult
extends JestResult {
    public UpdateByQueryResult(Gson gson) {
        super(gson);
    }

    public boolean didTimeOut() {
        return this.jsonObject != null && this.jsonObject.has("timed_out") ? this.jsonObject.get("timed_out").getAsBoolean() : false;
    }

    public long getConflictsCount() {
        return this.jsonObject != null && this.jsonObject.has("version_conflicts") ? this.jsonObject.get("version_conflicts").getAsLong() : 0L;
    }

    public long getMillisTaken() {
        return this.jsonObject != null && this.jsonObject.has("took") ? this.jsonObject.get("took").getAsLong() : 0L;
    }

    public long getUpdatedCount() {
        return this.jsonObject != null && this.jsonObject.has("updated") ? this.jsonObject.get("updated").getAsLong() : 0L;
    }

    public int getBatchCount() {
        return this.jsonObject != null && this.jsonObject.has("batches") ? this.jsonObject.get("batches").getAsInt() : 0;
    }

    public int getRetryCount() {
        return this.getBulkRetryCount() + this.getSearchRetryCount();
    }

    public int getBulkRetryCount() {
        return this.jsonObject != null && this.jsonObject.has("retries") && this.jsonObject.getAsJsonObject("retries").has("bulk") ? this.jsonObject.getAsJsonObject("retries").get("bulk").getAsInt() : 0;
    }

    public int getSearchRetryCount() {
        return this.jsonObject != null && this.jsonObject.has("retries") && this.jsonObject.getAsJsonObject("retries").has("search") ? this.jsonObject.getAsJsonObject("retries").get("search").getAsInt() : 0;
    }

    public int getNoopCount() {
        return this.jsonObject != null && this.jsonObject.has("noops") ? this.jsonObject.get("noops").getAsInt() : 0;
    }

    public JsonArray getFailures() {
        return this.jsonObject != null && this.jsonObject.has("failures") ? this.jsonObject.get("failures").getAsJsonArray() : null;
    }

    public String toString() {
        return "Updated: " + this.getUpdatedCount() + ", conflicts: " + this.getConflictsCount() + ", time taken: " + this.getMillisTaken() + ", did time out: " + this.didTimeOut() + ", batches: " + this.getBatchCount() + ", retries: " + this.getRetryCount() + ", bulk retries: " + this.getBulkRetryCount() + ", search retries: " + this.getSearchRetryCount() + ", noops: " + this.getNoopCount();
    }
}

