/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.ryantenney.metrics.spring.AbstractAnnotationBeanPostProcessor;
import com.ryantenney.metrics.spring.AnnotationFilter;
import com.ryantenney.metrics.spring.Util;
import java.lang.reflect.Method;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

class GaugeMethodAnnotationBeanPostProcessor
extends AbstractAnnotationBeanPostProcessor
implements Ordered {
    private static final AnnotationFilter FILTER = new AnnotationFilter(com.codahale.metrics.annotation.Gauge.class, 2487);
    private final MetricRegistry metrics;

    public GaugeMethodAnnotationBeanPostProcessor(MetricRegistry metrics) {
        super(AbstractAnnotationBeanPostProcessor.Members.ALL, AbstractAnnotationBeanPostProcessor.Phase.POST_INIT, FILTER);
        this.metrics = metrics;
    }

    @Override
    protected void withMethod(final Object bean, String beanName, Class<?> targetClass, final Method method) {
        if (method.getParameterTypes().length > 0) {
            throw new IllegalStateException("Method " + method.getName() + " is annotated with @Gauge but requires parameters.");
        }
        com.codahale.metrics.annotation.Gauge annotation = method.getAnnotation(com.codahale.metrics.annotation.Gauge.class);
        String metricName = Util.forGauge(targetClass, method, annotation);
        this.metrics.register(metricName, (Metric)new Gauge<Object>(){

            public Object getValue() {
                return ReflectionUtils.invokeMethod((Method)method, (Object)bean);
            }
        });
        this.LOG.debug("Created gauge {} for method {}.{}", new Object[]{metricName, targetClass.getCanonicalName(), method.getName()});
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

