/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.common.base.Preconditions;
import com.google.firebase.internal.RetryConfig;
import com.google.firebase.internal.RetryUnsuccessfulResponseHandler;
import java.io.IOException;

final class RetryInitializer
implements HttpRequestInitializer {
    private final RetryConfig retryConfig;

    RetryInitializer(RetryConfig retryConfig) {
        this.retryConfig = (RetryConfig)Preconditions.checkNotNull((Object)retryConfig);
    }

    public void initialize(HttpRequest request) {
        request.setNumberOfRetries(this.retryConfig.getMaxRetries());
        request.setUnsuccessfulResponseHandler(this.newUnsuccessfulResponseHandler(request));
        if (this.retryConfig.isRetryOnIOExceptions()) {
            request.setIOExceptionHandler(this.newIOExceptionHandler());
        }
    }

    private HttpUnsuccessfulResponseHandler newUnsuccessfulResponseHandler(HttpRequest request) {
        RetryUnsuccessfulResponseHandler retryHandler = new RetryUnsuccessfulResponseHandler(this.retryConfig);
        return new RetryHandlerDecorator(retryHandler, request);
    }

    private HttpIOExceptionHandler newIOExceptionHandler() {
        return new HttpBackOffIOExceptionHandler(this.retryConfig.newBackOff()).setSleeper(this.retryConfig.getSleeper());
    }

    static class RetryHandlerDecorator
    implements HttpUnsuccessfulResponseHandler {
        private final RetryUnsuccessfulResponseHandler retryHandler;
        private final HttpUnsuccessfulResponseHandler preRetryHandler;

        private RetryHandlerDecorator(RetryUnsuccessfulResponseHandler retryHandler, HttpRequest request) {
            this.retryHandler = (RetryUnsuccessfulResponseHandler)Preconditions.checkNotNull((Object)retryHandler);
            HttpUnsuccessfulResponseHandler preRetryHandler = request.getUnsuccessfulResponseHandler();
            if (preRetryHandler == null) {
                preRetryHandler = new HttpUnsuccessfulResponseHandler(){

                    public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) {
                        return false;
                    }
                };
            }
            this.preRetryHandler = preRetryHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
            try {
                boolean retry = this.preRetryHandler.handleResponse(request, response, supportsRetry);
                if (!retry) {
                    retry = this.retryHandler.handleResponse(request, response, supportsRetry);
                }
                boolean bl = retry;
                return bl;
            }
            finally {
                request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)this);
            }
        }

        RetryUnsuccessfulResponseHandler getRetryHandler() {
            return this.retryHandler;
        }
    }
}

