/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.alts.internal.AeadCrypter;
import io.grpc.alts.internal.AesGcmHkdfAeadCrypter;
import io.grpc.alts.internal.ChannelCrypterNetty;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.List;

final class AltsChannelCrypter
implements ChannelCrypterNetty {
    private static final int KEY_LENGTH = AesGcmHkdfAeadCrypter.getKeyLength();
    private static final int COUNTER_LENGTH = 12;
    private static final int COUNTER_OVERFLOW_LENGTH = 8;
    private static final int TAG_LENGTH = 16;
    private final AeadCrypter aeadCrypter;
    private final byte[] outCounter = new byte[12];
    private final byte[] inCounter = new byte[12];
    private final byte[] oldCounter = new byte[12];

    AltsChannelCrypter(byte[] key, boolean isClient) {
        Preconditions.checkArgument((key.length == KEY_LENGTH ? 1 : 0) != 0);
        byte[] counter = isClient ? this.inCounter : this.outCounter;
        counter[counter.length - 1] = -128;
        this.aeadCrypter = new AesGcmHkdfAeadCrypter(key);
    }

    static int getKeyLength() {
        return KEY_LENGTH;
    }

    static int getCounterLength() {
        return 12;
    }

    @Override
    public void encrypt(ByteBuf outBuf, List<ByteBuf> plainBufs) throws GeneralSecurityException {
        byte[] tempArr = new byte[outBuf.writableBytes()];
        ByteBuf tempBuf = Unpooled.wrappedBuffer((byte[])tempArr, (int)0, (int)(tempArr.length - 16));
        tempBuf.resetWriterIndex();
        for (ByteBuf plainBuf : plainBufs) {
            tempBuf.writeBytes(plainBuf);
        }
        ByteBuffer out = ByteBuffer.wrap(tempArr);
        ByteBuffer plain = ByteBuffer.wrap(tempArr, 0, tempArr.length - 16);
        byte[] counter = this.incrementOutCounter();
        this.aeadCrypter.encrypt(out, plain, counter);
        outBuf.writeBytes(tempArr);
    }

    @Override
    public void decrypt(ByteBuf outBuf, ByteBuf tagBuf, List<ByteBuf> ciphertextBufs) throws GeneralSecurityException {
        byte[] tempArr = new byte[outBuf.writableBytes()];
        ByteBuf tempBuf = Unpooled.wrappedBuffer((byte[])tempArr);
        tempBuf.resetWriterIndex();
        for (ByteBuf ciphertextBuf : ciphertextBufs) {
            tempBuf.writeBytes(ciphertextBuf);
        }
        tempBuf.writeBytes(tagBuf);
        this.decryptInternal(outBuf, tempArr);
    }

    @Override
    public void decrypt(ByteBuf outBuf, ByteBuf ciphertextAndTagDirect) throws GeneralSecurityException {
        byte[] tempArr = new byte[ciphertextAndTagDirect.readableBytes()];
        ByteBuf tempBuf = Unpooled.wrappedBuffer((byte[])tempArr);
        tempBuf.resetWriterIndex();
        tempBuf.writeBytes(ciphertextAndTagDirect);
        this.decryptInternal(outBuf, tempArr);
    }

    private void decryptInternal(ByteBuf outBuf, byte[] tempArr) throws GeneralSecurityException {
        ByteBuffer ciphertextAndTag = ByteBuffer.wrap(tempArr);
        ByteBuffer out = ByteBuffer.wrap(tempArr);
        byte[] counter = this.incrementInCounter();
        this.aeadCrypter.decrypt(out, ciphertextAndTag, counter);
        outBuf.writeBytes(tempArr, 0, tempArr.length - 16);
    }

    @Override
    public int getSuffixLength() {
        return 16;
    }

    @Override
    public void destroy() {
    }

    static void incrementCounter(byte[] counter, byte[] oldCounter) throws GeneralSecurityException {
        int i;
        System.arraycopy(counter, 0, oldCounter, 0, counter.length);
        for (i = 0; i < 8; ++i) {
            int n = i;
            counter[n] = (byte)(counter[n] + 1);
            if (counter[i] != 0) break;
        }
        if (i == 8) {
            System.arraycopy(oldCounter, 0, counter, 0, counter.length);
            throw new GeneralSecurityException("Counter has overflowed.");
        }
    }

    private byte[] incrementInCounter() throws GeneralSecurityException {
        AltsChannelCrypter.incrementCounter(this.inCounter, this.oldCounter);
        return this.oldCounter;
    }

    private byte[] incrementOutCounter() throws GeneralSecurityException {
        AltsChannelCrypter.incrementCounter(this.outCounter, this.oldCounter);
        return this.oldCounter;
    }

    @VisibleForTesting
    void incrementInCounterForTesting(int n) throws GeneralSecurityException {
        for (int i = 0; i < n; ++i) {
            this.incrementInCounter();
        }
    }

    @VisibleForTesting
    void incrementOutCounterForTesting(int n) throws GeneralSecurityException {
        for (int i = 0; i < n; ++i) {
            this.incrementOutCounter();
        }
    }
}

