/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorType;
import java.util.Map;

public class AviatorDouble
extends AviatorNumber {
    public AviatorDouble(double d) {
        super(d);
    }

    AviatorDouble(Number number) {
        super(number);
    }

    public static AviatorDouble valueOf(double value) {
        return new AviatorDouble(value);
    }

    public static AviatorDouble valueOf(Double value) {
        return AviatorDouble.valueOf((double)value);
    }

    @Override
    public int innerCompare(Map<String, Object> env, AviatorNumber other) {
        return Double.compare(this.doubleValue, other.doubleValue());
    }

    @Override
    public AviatorObject neg(Map<String, Object> env) {
        return new AviatorDouble(-this.doubleValue);
    }

    @Override
    public AviatorObject innerDiv(Map<String, Object> env, AviatorNumber other) {
        return new AviatorDouble(this.doubleValue / other.doubleValue());
    }

    @Override
    public AviatorNumber innerAdd(Map<String, Object> env, AviatorNumber other) {
        return new AviatorDouble(this.doubleValue + other.doubleValue());
    }

    @Override
    public AviatorObject innerMod(Map<String, Object> env, AviatorNumber other) {
        return new AviatorDouble(this.doubleValue % other.doubleValue());
    }

    @Override
    public AviatorObject innerMult(Map<String, Object> env, AviatorNumber other) {
        return new AviatorDouble(this.doubleValue * other.doubleValue());
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue;
    }

    @Override
    public double doubleValue() {
        return this.doubleValue;
    }

    @Override
    public Object getValue(Map<String, Object> env) {
        return this.doubleValue;
    }

    @Override
    public AviatorType getAviatorType() {
        return AviatorType.Double;
    }

    @Override
    public AviatorObject innerSub(Map<String, Object> env, AviatorNumber other) {
        return new AviatorDouble(this.doubleValue - other.doubleValue());
    }
}

