/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.Blob;
import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.GeoPoint;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.UserDataConverter;
import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.Value;
import com.google.firestore.v1.Write;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
public class DocumentSnapshot {
    private final FirestoreRpcContext<?> rpcContext;
    private final DocumentReference docRef;
    @Nullable
    private final Map<String, Value> fields;
    @Nullable
    private final Timestamp readTime;
    @Nullable
    private final Timestamp updateTime;
    @Nullable
    private final Timestamp createTime;

    DocumentSnapshot(FirestoreRpcContext<?> rpcContext, DocumentReference docRef, @Nullable Map<String, Value> fields, @Nullable Timestamp readTime, @Nullable Timestamp updateTime, @Nullable Timestamp createTime) {
        this.rpcContext = rpcContext;
        this.docRef = docRef;
        this.fields = fields;
        this.readTime = readTime;
        this.updateTime = updateTime;
        this.createTime = createTime;
    }

    @Nonnull
    public String getId() {
        return this.docRef.getId();
    }

    static DocumentSnapshot fromObject(FirestoreRpcContext<?> rpcContext, DocumentReference docRef, Map<String, Object> values, UserDataConverter.EncodingOptions options) {
        HashMap<String, Value> fields = new HashMap<String, Value>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Value encodedValue = UserDataConverter.encodeValue(FieldPath.of(entry.getKey()), CustomClassMapper.convertToPlainJavaTypes(entry.getValue()), options);
            if (encodedValue == null) continue;
            fields.put(entry.getKey(), encodedValue);
        }
        return new DocumentSnapshot(rpcContext, docRef, fields, null, null, null);
    }

    static DocumentSnapshot fromDocument(FirestoreRpcContext<?> rpcContext, Timestamp readTime, Document document) {
        return new DocumentSnapshot(rpcContext, new DocumentReference(rpcContext, ResourcePath.create(document.getName())), document.getFieldsMap(), readTime, Timestamp.fromProto((com.google.protobuf.Timestamp)document.getUpdateTime()), Timestamp.fromProto((com.google.protobuf.Timestamp)document.getCreateTime()));
    }

    static DocumentSnapshot fromMissing(FirestoreRpcContext<?> rpcContext, DocumentReference documentReference, Timestamp readTime) {
        return new DocumentSnapshot(rpcContext, documentReference, null, readTime, null, null);
    }

    private Object decodeValue(Value v) {
        Value.ValueTypeCase typeCase = v.getValueTypeCase();
        switch (typeCase) {
            case NULL_VALUE: {
                return null;
            }
            case BOOLEAN_VALUE: {
                return v.getBooleanValue();
            }
            case INTEGER_VALUE: {
                return v.getIntegerValue();
            }
            case DOUBLE_VALUE: {
                return v.getDoubleValue();
            }
            case TIMESTAMP_VALUE: {
                return Timestamp.fromProto((com.google.protobuf.Timestamp)v.getTimestampValue());
            }
            case STRING_VALUE: {
                return v.getStringValue();
            }
            case BYTES_VALUE: {
                return Blob.fromByteString(v.getBytesValue());
            }
            case REFERENCE_VALUE: {
                String pathName = v.getReferenceValue();
                return new DocumentReference(this.rpcContext, ResourcePath.create(pathName));
            }
            case GEO_POINT_VALUE: {
                return new GeoPoint(v.getGeoPointValue().getLatitude(), v.getGeoPointValue().getLongitude());
            }
            case ARRAY_VALUE: {
                ArrayList<Object> list = new ArrayList<Object>();
                List lv = v.getArrayValue().getValuesList();
                for (Value iv : lv) {
                    list.add(this.decodeValue(iv));
                }
                return list;
            }
            case MAP_VALUE: {
                HashMap outputMap = new HashMap();
                Map inputMap = v.getMapValue().getFieldsMap();
                for (Map.Entry entry : inputMap.entrySet()) {
                    outputMap.put(entry.getKey(), this.decodeValue((Value)entry.getValue()));
                }
                return outputMap;
            }
        }
        throw FirestoreException.invalidState(String.format("Unknown Value Type: %s", typeCase), new Object[0]);
    }

    @Nullable
    public Timestamp getReadTime() {
        return this.readTime;
    }

    @Nullable
    public Timestamp getUpdateTime() {
        return this.updateTime;
    }

    @Nullable
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public boolean exists() {
        return this.fields != null;
    }

    @Nullable
    public Map<String, Object> getData() {
        if (this.fields == null) {
            return null;
        }
        HashMap<String, Object> decodedFields = new HashMap<String, Object>();
        for (Map.Entry<String, Value> entry : this.fields.entrySet()) {
            Object decodedValue = this.decodeValue(entry.getValue());
            decodedValue = this.convertToDateIfNecessary(decodedValue);
            decodedFields.put(entry.getKey(), decodedValue);
        }
        return decodedFields;
    }

    @Nullable
    public <T> T toObject(@Nonnull Class<T> valueType) {
        Map<String, Object> data = this.getData();
        return data == null ? null : (T)CustomClassMapper.convertToCustomClass(data, valueType, this.docRef);
    }

    public boolean contains(@Nonnull String field) {
        return this.contains(FieldPath.fromDotSeparatedString(field));
    }

    public boolean contains(@Nonnull FieldPath fieldPath) {
        return this.extractField(fieldPath) != null;
    }

    @Nullable
    public Object get(@Nonnull String field) {
        return this.get(FieldPath.fromDotSeparatedString(field));
    }

    @Nullable
    public <T> T get(@Nonnull String field, @Nonnull Class<T> valueType) {
        return this.get(FieldPath.fromDotSeparatedString(field), valueType);
    }

    @Nullable
    public Object get(@Nonnull FieldPath fieldPath) {
        Value value = this.extractField(fieldPath);
        if (value == null) {
            return null;
        }
        Object decodedValue = this.decodeValue(value);
        return this.convertToDateIfNecessary(decodedValue);
    }

    @Nullable
    public <T> T get(@Nonnull FieldPath fieldPath, Class<T> valueType) {
        Object data = this.get(fieldPath);
        return data == null ? null : (T)CustomClassMapper.convertToCustomClass(data, valueType, this.docRef);
    }

    private Object convertToDateIfNecessary(Object decodedValue) {
        if (decodedValue instanceof Timestamp && !this.rpcContext.areTimestampsInSnapshotsEnabled()) {
            decodedValue = ((Timestamp)decodedValue).toDate();
        }
        return decodedValue;
    }

    @Nullable
    Value extractField(@Nonnull FieldPath fieldPath) {
        Value value = null;
        if (this.fields != null) {
            UnmodifiableIterator components = fieldPath.getSegments().iterator();
            value = this.fields.get(components.next());
            while (value != null && components.hasNext()) {
                if (value.getValueTypeCase() != Value.ValueTypeCase.MAP_VALUE) {
                    return null;
                }
                value = value.getMapValue().getFieldsOrDefault((String)components.next(), null);
            }
        }
        return value;
    }

    @Nullable
    public Boolean getBoolean(@Nonnull String field) {
        return (Boolean)this.get(field);
    }

    @Nullable
    public Double getDouble(@Nonnull String field) {
        Number number = (Number)this.get(field);
        return number == null ? null : Double.valueOf(number.doubleValue());
    }

    @Nullable
    public String getString(@Nonnull String field) {
        return (String)this.get(field);
    }

    @Nullable
    public Long getLong(@Nonnull String field) {
        Number number = (Number)this.get(field);
        return number == null ? null : Long.valueOf(number.longValue());
    }

    @Nullable
    public Date getDate(@Nonnull String field) {
        return ((Timestamp)this.get(field)).toDate();
    }

    @Nullable
    public Timestamp getTimestamp(@Nonnull String field) {
        return (Timestamp)this.get(field);
    }

    @Nullable
    public Blob getBlob(@Nonnull String field) {
        return (Blob)this.get(field);
    }

    @Nullable
    public GeoPoint getGeoPoint(@Nonnull String field) {
        return (GeoPoint)this.get(field);
    }

    @Nonnull
    public DocumentReference getReference() {
        return this.docRef;
    }

    boolean isEmpty() {
        return this.fields == null || this.fields.isEmpty();
    }

    Map<String, Value> getProtoFields() {
        return this.fields;
    }

    Write.Builder toPb() {
        Preconditions.checkState((boolean)this.exists(), (Object)"Can't call toDocument() on a document that doesn't exist");
        Write.Builder write = Write.newBuilder();
        Document.Builder document = write.getUpdateBuilder();
        document.setName(this.docRef.getName());
        document.putAllFields(this.fields);
        return write;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DocumentSnapshot)) {
            return false;
        }
        DocumentSnapshot that = (DocumentSnapshot)obj;
        return Objects.equals(this.rpcContext, that.rpcContext) && Objects.equals(this.docRef, that.docRef) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.rpcContext, this.docRef, this.fields);
    }
}

