/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import javax.validation.constraints.Size;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.RangeAnnotations;
import springfox.bean.validators.plugins.Validators;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Order(value=-2147483148)
public class SizeAnnotationPlugin
implements ModelPropertyBuilderPlugin {
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ModelPropertyContext context) {
        Optional<Size> size = this.extractAnnotation(context);
        if (size.isPresent()) {
            context.getBuilder().allowableValues((AllowableValues)RangeAnnotations.stringLengthRange((Size)size.get()));
        }
    }

    @VisibleForTesting
    Optional<Size> extractAnnotation(ModelPropertyContext context) {
        return Validators.annotationFromBean(context, Size.class).or(Validators.annotationFromField(context, Size.class));
    }
}

