/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.system;

import com.googlecode.aviator.runtime.function.AbstractVariadicFunction;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.AviatorObject;
import java.util.Map;

public abstract class AbstractMinMaxFunction
extends AbstractVariadicFunction {
    @Override
    public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
        if (args == null || args.length == 0) {
            return AviatorNil.NIL;
        }
        boolean wasFirst = true;
        AviatorObject result = AviatorNil.NIL;
        for (AviatorObject obj : args) {
            result = this.compareObjects(env, result, obj, wasFirst);
            if (wasFirst) {
                wasFirst = false;
            }
            if (this.getOp() == Op.Min && result.isNull(env)) break;
        }
        return result;
    }

    protected abstract Op getOp();

    private AviatorObject compareObjects(Map<String, Object> env, AviatorObject result, AviatorObject obj, boolean wasFirst) {
        if (obj.isNull(env)) {
            switch (this.getOp()) {
                case Min: {
                    return obj;
                }
                case Max: {
                    return result;
                }
            }
        }
        if (wasFirst || this.compare(env, result, obj)) {
            result = obj;
        }
        return result;
    }

    private boolean compare(Map<String, Object> env, AviatorObject result, AviatorObject obj) {
        int c = obj.compare(result, env);
        switch (this.getOp()) {
            case Min: {
                return c < 0;
            }
            case Max: {
                return c > 0;
            }
        }
        return false;
    }

    static enum Op {
        Min,
        Max;

    }
}

