/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.utils;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Env
implements Map<String, Object> {
    private final Map<String, Object> mDefaults;
    private AviatorEvaluatorInstance instance;
    private Map<String, Object> mOverrides;
    public static final Map<String, Object> EMPTY_ENV = Collections.emptyMap();
    private Map<String, String> capturedVars;

    public Map<String, Object> getDefaults() {
        return this.mDefaults;
    }

    public AviatorEvaluatorInstance getInstance() {
        return this.instance;
    }

    public void setInstance(AviatorEvaluatorInstance instance) {
        this.instance = instance;
    }

    public void capture(String var, String expression) {
        if (this.capturedVars == null) {
            this.capturedVars = new HashMap<String, String>();
        }
        this.capturedVars.put(var, expression);
    }

    public Env() {
        this(EMPTY_ENV);
    }

    public Env(Map<String, Object> defaults) {
        this.mDefaults = defaults;
    }

    public Env(Map<String, Object> defaults, Map<String, Object> overrides) {
        this.mDefaults = defaults;
        this.mOverrides = overrides;
    }

    @Override
    public void clear() {
        if (this.mDefaults != EMPTY_ENV) {
            this.mDefaults.clear();
        }
        if (this.mOverrides != null && this.mOverrides != EMPTY_ENV) {
            this.mOverrides.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        Map<String, Object> overrides = this.getmOverrides(true);
        if (overrides.containsKey(key)) {
            return overrides.get(key) != null;
        }
        return this.mDefaults.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getmOverrides(true).containsValue(value) || this.mDefaults.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> ret = new HashSet<Map.Entry<String, Object>>(this.mDefaults.entrySet());
        ret.addAll(this.getmOverrides(true).entrySet());
        return ret;
    }

    @Override
    public Object get(Object key) {
        if ("__env__".equals(key)) {
            return this;
        }
        Map<String, Object> overrides = this.getmOverrides(true);
        Object ret = null;
        ret = overrides.containsKey(key) ? overrides.get(key) : this.mDefaults.get(key);
        if (ret == null && "__instance__".equals(key)) {
            return this.instance;
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.getmOverrides(true).isEmpty() && this.mDefaults.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> ret = new HashSet<String>(this.mDefaults.keySet());
        ret.addAll(this.getmOverrides(true).keySet());
        return ret;
    }

    @Override
    public Object put(String key, Object value) {
        Object prior;
        Object capturedExp = null;
        if (this.capturedVars != null && this.capturedVars.containsKey(key)) {
            throw new ExpressionRuntimeException("Can't assignment value to captured variable.The `" + key + "` is already captured by lambda.");
        }
        Map<String, Object> overrides = this.getmOverrides(false);
        if (overrides.containsKey(key)) {
            prior = overrides.put(key, value);
        } else {
            overrides.put(key, value);
            prior = this.mDefaults.get(key);
        }
        return prior;
    }

    @Override
    public void putAll(Map map) {
        this.getmOverrides(false).putAll(map);
    }

    @Override
    public Object remove(Object key) {
        if (this.getmOverrides(false).containsKey(key)) {
            return this.getmOverrides(false).remove(key);
        }
        return this.mDefaults.remove(key);
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (String key : this.keySet()) {
            vals.add(this.get(key));
        }
        return vals;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(32 * this.size());
        buf.append(super.toString()).append("{").append("__instance__").append("=").append(this.instance).append(", ").append("__env__").append("=").append("<this>");
        Iterator<String> it = this.keySet().iterator();
        boolean hasNext = it.hasNext();
        if (hasNext) {
            buf.append(", ");
        }
        while (hasNext) {
            String key = it.next();
            Object value = this.get(key);
            buf.append(key).append('=').append(value == this ? "<this>" : value);
            hasNext = it.hasNext();
            if (!hasNext) continue;
            buf.append(',').append(' ');
        }
        buf.append('}');
        return buf.toString();
    }

    private Map<String, Object> getmOverrides(boolean readOnly) {
        if (this.mOverrides == null) {
            if (readOnly) {
                return EMPTY_ENV;
            }
            this.mOverrides = new HashMap<String, Object>();
        }
        return this.mOverrides;
    }
}

