/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class SeqSortFunction
extends AbstractFunction {
    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        Object first = arg1.getValue(env);
        if (first == null) {
            throw new NullPointerException("null seq");
        }
        Class<?> clazz = first.getClass();
        if (List.class.isAssignableFrom(clazz)) {
            List list = (List)first;
            Object[] a = list.toArray();
            Arrays.sort(a);
            return new AviatorRuntimeJavaType(Arrays.asList(a));
        }
        if (clazz.isArray()) {
            int length = Array.getLength(first);
            Object[] dup = (Object[])Array.newInstance(first.getClass().getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                dup[i] = Array.get(first, i);
            }
            Arrays.sort(dup);
            return new AviatorRuntimeJavaType(dup);
        }
        throw new IllegalArgumentException(arg1.desc(env) + " is not a seq");
    }

    @Override
    public String getName() {
        return "sort";
    }
}

