/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hppc.deser;

import com.carrotsearch.hppc.ByteContainer;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.FloatContainer;
import com.carrotsearch.hppc.IntArrayDeque;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntDeque;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.ShortContainer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.datatype.hppc.deser.ContainerDeserializerBase;
import java.io.IOException;
import java.util.HashMap;

public class HppcContainerDeserializers {
    protected static final HashMap<Class<?>, Class<?>> _concreteMapping = new HashMap();

    public static JsonDeserializer<?> findDeserializer(DeserializationConfig config, JavaType origType) throws JsonMappingException {
        JavaType type = origType;
        Class<?> raw = type.getRawClass();
        if (IntContainer.class.isAssignableFrom(raw)) {
            Class<?> concrete;
            if (type.isAbstract() && (concrete = _concreteMapping.get(raw)) != null) {
                type = config.getTypeFactory().constructSpecializedType(type, concrete);
                raw = concrete;
            }
            if (IntIndexedContainer.class.isAssignableFrom(raw)) {
                return new IntIndexedContainerDeserializer(type, config);
            }
            if (IntSet.class.isAssignableFrom(raw)) {
                return new IntSetDeserializer(type, config);
            }
            if (IntDeque.class.isAssignableFrom(raw)) {
                return new IntDequeDeserializer(type, config);
            }
            throw JsonMappingException.from((JsonParser)null, (String)("Unrecognized HPPC IntContainer type: " + origType));
        }
        if (LongContainer.class.isAssignableFrom(raw) || FloatContainer.class.isAssignableFrom(raw) || DoubleContainer.class.isAssignableFrom(raw) || ByteContainer.class.isAssignableFrom(raw) || ShortContainer.class.isAssignableFrom(raw) || CharContainer.class.isAssignableFrom(raw)) {
            // empty if block
        }
        return null;
    }

    static {
        _concreteMapping.put(IntContainer.class, IntArrayList.class);
        _concreteMapping.put(IntIndexedContainer.class, IntArrayList.class);
        _concreteMapping.put(IntSet.class, IntHashSet.class);
        _concreteMapping.put(IntDeque.class, IntArrayDeque.class);
    }

    static class IntDequeDeserializer
    extends IntContainerDeserializerBase<IntDeque> {
        private static final long serialVersionUID = 1L;

        public IntDequeDeserializer(JavaType type, DeserializationConfig config) {
            super(type, config);
        }

        @Override
        protected void add(IntDeque container, int value) {
            container.addLast(value);
        }
    }

    static class IntIndexedContainerDeserializer
    extends IntContainerDeserializerBase<IntIndexedContainer> {
        private static final long serialVersionUID = 1L;

        public IntIndexedContainerDeserializer(JavaType type, DeserializationConfig config) {
            super(type, config);
        }

        @Override
        protected void add(IntIndexedContainer container, int value) {
            container.add(value);
        }
    }

    static class IntSetDeserializer
    extends IntContainerDeserializerBase<IntSet> {
        private static final long serialVersionUID = 1L;

        public IntSetDeserializer(JavaType type, DeserializationConfig config) {
            super(type, config);
        }

        @Override
        protected void add(IntSet container, int value) {
            container.add(value);
        }
    }

    static abstract class IntContainerDeserializerBase<T>
    extends ContainerDeserializerBase<T> {
        public IntContainerDeserializerBase(JavaType type, DeserializationConfig config) {
            super(type, config);
        }

        @Override
        public void deserializeContents(JsonParser p, DeserializationContext ctxt, T container) throws IOException {
            JsonToken t;
            while ((t = p.nextToken()) != JsonToken.END_ARRAY) {
                int value;
                if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
                    value = p.getIntValue();
                } else {
                    if (t != JsonToken.VALUE_NULL) {
                        ctxt.handleUnexpectedToken(this._valueClass, p);
                        return;
                    }
                    value = 0;
                }
                this.add(container, value);
            }
        }

        protected abstract void add(T var1, int var2);
    }
}

