/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shrink;

import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.shrink.ShrinkAction;
import org.elasticsearch.action.admin.indices.shrink.ShrinkRequest;
import org.elasticsearch.action.admin.indices.shrink.ShrinkResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.master.AcknowledgedRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.settings.Settings;

public class ShrinkRequestBuilder
extends AcknowledgedRequestBuilder<ShrinkRequest, ShrinkResponse, ShrinkRequestBuilder> {
    public ShrinkRequestBuilder(ElasticsearchClient client, ShrinkAction action) {
        super(client, action, new ShrinkRequest());
    }

    public ShrinkRequestBuilder setTargetIndex(CreateIndexRequest request) {
        ((ShrinkRequest)this.request).setShrinkIndex(request);
        return this;
    }

    public ShrinkRequestBuilder setSourceIndex(String index) {
        ((ShrinkRequest)this.request).setSourceIndex(index);
        return this;
    }

    public ShrinkRequestBuilder setSettings(Settings settings) {
        ((ShrinkRequest)this.request).getShrinkIndexRequest().settings(settings);
        return this;
    }

    public ShrinkRequestBuilder setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        ((ShrinkRequest)this.request).setWaitForActiveShards(waitForActiveShards);
        return this;
    }

    public ShrinkRequestBuilder setWaitForActiveShards(int waitForActiveShards) {
        return this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }
}

