/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.utils.TypeUtils;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;

public class SeqGetFunction
extends AbstractFunction {
    @Override
    public String getName() {
        return "seq.get";
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        Object coll = arg1.getValue(env);
        Object key = arg2.getValue(env);
        if (coll == null) {
            throw new NullPointerException("null seq");
        }
        Class<?> clazz = coll.getClass();
        if (List.class.isAssignableFrom(clazz)) {
            if (!TypeUtils.isLong(key)) {
                throw new IllegalArgumentException("Invalid index `" + key + "` for list,it's not a integer.");
            }
            Object value = ((List)coll).get(((Number)key).intValue());
            return AviatorRuntimeJavaType.valueOf(value);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Object value = ((Map)coll).get(key);
            return AviatorRuntimeJavaType.valueOf(value);
        }
        if (clazz.isArray()) {
            if (!TypeUtils.isLong(key)) {
                throw new IllegalArgumentException("Invalid index `" + key + "` for array,it's not a integer.");
            }
            return AviatorRuntimeJavaType.valueOf(Array.get(coll, ((Number)key).intValue()));
        }
        throw new IllegalArgumentException(arg1.desc(env) + " is not a collection.");
    }
}

