/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.geo;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.annotation.PersistenceConstructor;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GeoResults<T>
implements Iterable<GeoResult<T>>,
Serializable {
    private static final long serialVersionUID = 8347363491300219485L;
    private final List<? extends GeoResult<T>> results;
    private final Distance averageDistance;

    public GeoResults(List<? extends GeoResult<T>> results) {
        this(results, Metrics.NEUTRAL);
    }

    public GeoResults(List<? extends GeoResult<T>> results, Metric metric) {
        this(results, GeoResults.calculateAverageDistance(results, metric));
    }

    @PersistenceConstructor
    public GeoResults(List<? extends GeoResult<T>> results, Distance averageDistance) {
        Assert.notNull(results, (String)"Results must not be null!");
        Assert.notNull((Object)averageDistance, (String)"Average Distance must not be null!");
        this.results = results;
        this.averageDistance = averageDistance;
    }

    public Distance getAverageDistance() {
        return this.averageDistance;
    }

    public List<GeoResult<T>> getContent() {
        return Collections.unmodifiableList(this.results);
    }

    @Override
    public Iterator<GeoResult<T>> iterator() {
        return this.results.iterator();
    }

    public String toString() {
        return String.format("GeoResults: [averageDistance: %s, results: %s]", this.averageDistance.toString(), StringUtils.collectionToCommaDelimitedString(this.results));
    }

    private static Distance calculateAverageDistance(List<? extends GeoResult<?>> results, Metric metric) {
        Assert.notNull(results, (String)"Results must not be null!");
        Assert.notNull((Object)metric, (String)"Metric must not be null!");
        if (results.isEmpty()) {
            return new Distance(0.0, metric);
        }
        double averageDistance = results.stream().mapToDouble(it -> it.getDistance().getValue()).average().orElse(0.0);
        return new Distance(averageDistance, metric);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeoResults)) {
            return false;
        }
        GeoResults other = (GeoResults)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<GeoResult<T>> this$results = this.results;
        List<? extends GeoResult<T>> other$results = other.results;
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        Distance this$averageDistance = this.getAverageDistance();
        Distance other$averageDistance = other.getAverageDistance();
        return !(this$averageDistance == null ? other$averageDistance != null : !((Object)this$averageDistance).equals(other$averageDistance));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeoResults;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<GeoResult<T>> $results = this.results;
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        Distance $averageDistance = this.getAverageDistance();
        result = result * 59 + ($averageDistance == null ? 43 : ((Object)$averageDistance).hashCode());
        return result;
    }
}

