/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.ryantenney.metrics.spring.reporter.AbstractReporterElementParser;
import com.ryantenney.metrics.spring.reporter.GangliaReporterFactoryBean;

public class GangliaReporterElementParser
extends AbstractReporterElementParser {
    private static final String UUID_STRING_REGEX = "^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$";

    @Override
    public String getType() {
        return "ganglia";
    }

    @Override
    protected Class<?> getBeanClass() {
        return GangliaReporterFactoryBean.class;
    }

    @Override
    protected void validate(AbstractReporterElementParser.ValidationContext c) {
        c.require("group");
        c.require("port", "^([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])$", "Port number is required and must be between 1-65536");
        c.require("udp-mode");
        c.require("period", "^(\\d+)\\s?(ns|us|ms|s|m|h|d)?$", "Period is required and must be in the form '\\d+(ns|us|ms|s|m|h|d)'");
        c.require("ttl", "^\\d+$");
        c.optional("spoof");
        c.optional("protocol", "^v?3\\.[01]$", "Protocol version must be 'v3.0' or 'v3.1'");
        c.optional("dmax", "^\\d+$");
        c.optional("tmax", "^\\d+$");
        c.optional("rate-unit", "^(?:DAY|HOUR|MINUTE|(?:MICRO|MILLI|NANO)?SECOND)S$", "Rate unit must be one of the enum constants from java.util.concurrent.TimeUnit");
        c.optional("duration-unit", "^(?:DAY|HOUR|MINUTE|(?:MICRO|MILLI|NANO)?SECOND)S$", "Duration unit must be one of the enum constants from java.util.concurrent.TimeUnit");
        c.optional("uuid", UUID_STRING_REGEX);
        c.optional("prefix");
        c.optional("prefix-supplier-ref");
        if (c.has("prefix") && c.has("prefix-supplier-ref")) {
            c.reject("prefix-supplier-ref", "Reporter element must not specify both the 'prefix' and 'prefix-supplier-ref' attributes");
        }
        c.optional("filter");
        c.optional("filter-ref");
        if (c.has("filter") && c.has("filter-ref")) {
            c.reject("filter-ref", "Reporter element must not specify both the 'filter' and 'filter-ref' attributes");
        }
        c.rejectUnmatchedProperties();
    }
}

