/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.util;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import java.util.Map;
import java.util.regex.Pattern;
import org.casbin.jcasbin.rbac.RoleManager;

public class BuiltInFunctions {
    public static boolean keyMatch(String key1, String key2) {
        int i = key2.indexOf(42);
        if (i == -1) {
            return key1.equals(key2);
        }
        if (key1.length() > i) {
            return key1.substring(0, i).equals(key2.substring(0, i));
        }
        return key1.equals(key2.substring(0, i));
    }

    public static boolean keyMatch2(String key1, String key2) {
        key2 = key2.replace("/*", "/.*");
        Pattern p = Pattern.compile("(.*):[^/]+(.*)");
        while (key2.contains("/:")) {
            key2 = "^" + p.matcher(key2).replaceAll("$1[^/]+$2") + "$";
        }
        return BuiltInFunctions.regexMatch(key1, key2);
    }

    public static boolean keyMatch3(String key1, String key2) {
        key2 = key2.replace("/*", "/.*");
        Pattern p = Pattern.compile("(.*)\\{[^/]+\\}(.*)");
        while (key2.contains("/{")) {
            key2 = p.matcher(key2).replaceAll("$1[^/]+$2");
        }
        return BuiltInFunctions.regexMatch(key1, key2);
    }

    public static boolean regexMatch(String key1, String key2) {
        return Pattern.matches(key2, key1);
    }

    public static boolean ipMatch(String ip1, String ip2) {
        IPAddress ipa2;
        IPAddress ipa1;
        IPAddressString ipas1 = new IPAddressString(ip1);
        try {
            ipas1.validateIPv4();
        }
        catch (AddressStringException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("invalid argument: ip1 in IPMatch() function is not an IP address.");
        }
        IPAddressString ipas2 = new IPAddressString(ip2);
        try {
            ipas2.validate();
        }
        catch (AddressStringException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("invalid argument: ip2 in IPMatch() function is neither an IP address nor a CIDR.");
        }
        if (ipas1.equals((Object)ipas2)) {
            return true;
        }
        try {
            ipa1 = ipas1.toAddress();
            ipa2 = ipas2.toAddress();
        }
        catch (AddressStringException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("invalid argument: ip1 or ip2 in IPMatch() function is not an IP address.");
        }
        Integer prefix = ipa2.getNetworkPrefixLength();
        IPAddress mask = ipa2.getNetwork().getNetworkMask(prefix.intValue(), false);
        return ipa1.mask(mask).equals((Object)ipas2.getHostAddress());
    }

    public static AviatorFunction generateGFunction(final String name, final RoleManager rm) {
        return new AbstractFunction(){

            public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
                String name1 = FunctionUtils.getStringValue((AviatorObject)arg1, env);
                String name2 = FunctionUtils.getStringValue((AviatorObject)arg2, env);
                if (rm == null) {
                    return AviatorBoolean.valueOf((boolean)name1.equals(name2));
                }
                boolean res = rm.hasLink(name1, name2, new String[0]);
                return AviatorBoolean.valueOf((boolean)res);
            }

            public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2, AviatorObject arg3) {
                String name1 = FunctionUtils.getStringValue((AviatorObject)arg1, env);
                String name2 = FunctionUtils.getStringValue((AviatorObject)arg2, env);
                if (rm == null) {
                    return AviatorBoolean.valueOf((boolean)name1.equals(name2));
                }
                String domain = FunctionUtils.getStringValue((AviatorObject)arg3, env);
                boolean res = rm.hasLink(name1, name2, domain);
                return AviatorBoolean.valueOf((boolean)res);
            }

            public String getName() {
                return name;
            }
        };
    }
}

