/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotShardsStats;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStats;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class SnapshotIndexStatus
implements Iterable<SnapshotIndexShardStatus>,
ToXContent {
    private final String index;
    private final Map<Integer, SnapshotIndexShardStatus> indexShards;
    private final SnapshotShardsStats shardsStats;
    private final SnapshotStats stats;

    SnapshotIndexStatus(String index, Collection<SnapshotIndexShardStatus> shards) {
        this.index = index;
        HashMap<Integer, SnapshotIndexShardStatus> indexShards = new HashMap<Integer, SnapshotIndexShardStatus>();
        this.stats = new SnapshotStats();
        for (SnapshotIndexShardStatus shard : shards) {
            indexShards.put(shard.getShardId().getId(), shard);
            this.stats.add(shard.getStats());
        }
        this.shardsStats = new SnapshotShardsStats(shards);
        this.indexShards = Collections.unmodifiableMap(indexShards);
    }

    public String getIndex() {
        return this.index;
    }

    public Map<Integer, SnapshotIndexShardStatus> getShards() {
        return this.indexShards;
    }

    public SnapshotShardsStats getShardsStats() {
        return this.shardsStats;
    }

    public SnapshotStats getStats() {
        return this.stats;
    }

    @Override
    public Iterator<SnapshotIndexShardStatus> iterator() {
        return this.indexShards.values().iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getIndex());
        this.shardsStats.toXContent(builder, params);
        this.stats.toXContent(builder, params);
        builder.startObject("shards");
        for (SnapshotIndexShardStatus shard : this.indexShards.values()) {
            shard.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String SHARDS = "shards";

        Fields() {
        }
    }
}

