/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate.quadedge;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.math.DD;

public class TrianglePredicate {
    public static boolean isInCircleNonRobust(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        boolean isInCircle = (a.x * a.x + a.y * a.y) * TrianglePredicate.triArea(b, c, p) - (b.x * b.x + b.y * b.y) * TrianglePredicate.triArea(a, c, p) + (c.x * c.x + c.y * c.y) * TrianglePredicate.triArea(a, b, p) - (p.x * p.x + p.y * p.y) * TrianglePredicate.triArea(a, b, c) > 0.0;
        return isInCircle;
    }

    public static boolean isInCircleNormalized(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        double adx = a.x - p.x;
        double ady = a.y - p.y;
        double alift = adx * adx + ady * ady;
        double bdx = b.x - p.x;
        double cdy = c.y - p.y;
        double cdx = c.x - p.x;
        double bdy = b.y - p.y;
        double bcdet = bdx * cdy - cdx * bdy;
        double blift = bdx * bdx + bdy * bdy;
        double cadet = cdx * ady - adx * cdy;
        double clift = cdx * cdx + cdy * cdy;
        double abdet = adx * bdy - bdx * ady;
        double disc = alift * bcdet + blift * cadet + clift * abdet;
        return disc > 0.0;
    }

    private static double triArea(Coordinate a, Coordinate b, Coordinate c) {
        return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
    }

    public static boolean isInCircleRobust(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        return TrianglePredicate.isInCircleNormalized(a, b, c, p);
    }

    public static boolean isInCircleDDSlow(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        DD px = DD.valueOf(p.x);
        DD py = DD.valueOf(p.y);
        DD ax = DD.valueOf(a.x);
        DD ay = DD.valueOf(a.y);
        DD bx = DD.valueOf(b.x);
        DD by = DD.valueOf(b.y);
        DD cx = DD.valueOf(c.x);
        DD cy = DD.valueOf(c.y);
        DD aTerm = ax.multiply(ax).add(ay.multiply(ay)).multiply(TrianglePredicate.triAreaDDSlow(bx, by, cx, cy, px, py));
        DD bTerm = bx.multiply(bx).add(by.multiply(by)).multiply(TrianglePredicate.triAreaDDSlow(ax, ay, cx, cy, px, py));
        DD cTerm = cx.multiply(cx).add(cy.multiply(cy)).multiply(TrianglePredicate.triAreaDDSlow(ax, ay, bx, by, px, py));
        DD pTerm = px.multiply(px).add(py.multiply(py)).multiply(TrianglePredicate.triAreaDDSlow(ax, ay, bx, by, cx, cy));
        DD sum = aTerm.subtract(bTerm).add(cTerm).subtract(pTerm);
        boolean isInCircle = sum.doubleValue() > 0.0;
        return isInCircle;
    }

    public static DD triAreaDDSlow(DD ax, DD ay, DD bx, DD by, DD cx, DD cy) {
        return bx.subtract(ax).multiply(cy.subtract(ay)).subtract(by.subtract(ay).multiply(cx.subtract(ax)));
    }

    public static boolean isInCircleDDFast(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        DD aTerm = DD.sqr(a.x).selfAdd(DD.sqr(a.y)).selfMultiply(TrianglePredicate.triAreaDDFast(b, c, p));
        DD bTerm = DD.sqr(b.x).selfAdd(DD.sqr(b.y)).selfMultiply(TrianglePredicate.triAreaDDFast(a, c, p));
        DD cTerm = DD.sqr(c.x).selfAdd(DD.sqr(c.y)).selfMultiply(TrianglePredicate.triAreaDDFast(a, b, p));
        DD pTerm = DD.sqr(p.x).selfAdd(DD.sqr(p.y)).selfMultiply(TrianglePredicate.triAreaDDFast(a, b, c));
        DD sum = aTerm.selfSubtract(bTerm).selfAdd(cTerm).selfSubtract(pTerm);
        boolean isInCircle = sum.doubleValue() > 0.0;
        return isInCircle;
    }

    public static DD triAreaDDFast(Coordinate a, Coordinate b, Coordinate c) {
        DD t1 = DD.valueOf(b.x).selfSubtract(a.x).selfMultiply(DD.valueOf(c.y).selfSubtract(a.y));
        DD t2 = DD.valueOf(b.y).selfSubtract(a.y).selfMultiply(DD.valueOf(c.x).selfSubtract(a.x));
        return t1.selfSubtract(t2);
    }

    public static boolean isInCircleDDNormalized(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        DD adx = DD.valueOf(a.x).selfSubtract(p.x);
        DD ady = DD.valueOf(a.y).selfSubtract(p.y);
        DD bdx = DD.valueOf(b.x).selfSubtract(p.x);
        DD bdy = DD.valueOf(b.y).selfSubtract(p.y);
        DD cdx = DD.valueOf(c.x).selfSubtract(p.x);
        DD cdy = DD.valueOf(c.y).selfSubtract(p.y);
        DD abdet = adx.multiply(bdy).selfSubtract(bdx.multiply(ady));
        DD bcdet = bdx.multiply(cdy).selfSubtract(cdx.multiply(bdy));
        DD cadet = cdx.multiply(ady).selfSubtract(adx.multiply(cdy));
        DD alift = adx.multiply(adx).selfAdd(ady.multiply(ady));
        DD blift = bdx.multiply(bdx).selfAdd(bdy.multiply(bdy));
        DD clift = cdx.multiply(cdx).selfAdd(cdy.multiply(cdy));
        DD sum = alift.selfMultiply(bcdet).selfAdd(blift.selfMultiply(cadet)).selfAdd(clift.selfMultiply(abdet));
        boolean isInCircle = sum.doubleValue() > 0.0;
        return isInCircle;
    }

    public static boolean isInCircleCC(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        Coordinate cc = Triangle.circumcentre(a, b, c);
        double ccRadius = a.distance(cc);
        double pRadiusDiff = p.distance(cc) - ccRadius;
        return pRadiusDiff <= 0.0;
    }

    private static void checkRobustInCircle(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        boolean nonRobustInCircle = TrianglePredicate.isInCircleNonRobust(a, b, c, p);
        boolean isInCircleDD = TrianglePredicate.isInCircleDDSlow(a, b, c, p);
        boolean isInCircleCC = TrianglePredicate.isInCircleCC(a, b, c, p);
        Coordinate circumCentre = Triangle.circumcentre(a, b, c);
        System.out.println("p radius diff a = " + Math.abs(p.distance(circumCentre) - a.distance(circumCentre)) / a.distance(circumCentre));
        if (nonRobustInCircle != isInCircleDD || nonRobustInCircle != isInCircleCC) {
            System.out.println("inCircle robustness failure (double result = " + nonRobustInCircle + ", DD result = " + isInCircleDD + ", CC result = " + isInCircleCC + ")");
            System.out.println(WKTWriter.toLineString(new CoordinateArraySequence(new Coordinate[]{a, b, c, p})));
            System.out.println("Circumcentre = " + WKTWriter.toPoint(circumCentre) + " radius = " + a.distance(circumCentre));
            System.out.println("p radius diff a = " + Math.abs(p.distance(circumCentre) / a.distance(circumCentre) - 1.0));
            System.out.println("p radius diff b = " + Math.abs(p.distance(circumCentre) / b.distance(circumCentre) - 1.0));
            System.out.println("p radius diff c = " + Math.abs(p.distance(circumCentre) / c.distance(circumCentre) - 1.0));
            System.out.println();
        }
    }
}

