/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.system;

import com.googlecode.aviator.utils.LRUMap;
import java.text.SimpleDateFormat;

public class DateFormatCache {
    private static int maxSize = Integer.valueOf(System.getProperty("aviator.date_format.cache.max", "256"));
    private static ThreadLocal<LRUMap<String, SimpleDateFormat>> formatCache = new ThreadLocal();

    public static SimpleDateFormat getOrCreateDateFormat(String format) {
        SimpleDateFormat rt;
        LRUMap<String, SimpleDateFormat> cache = formatCache.get();
        if (cache == null) {
            cache = new LRUMap(maxSize);
            formatCache.set(cache);
        }
        if ((rt = cache.get(format)) == null) {
            rt = new SimpleDateFormat(format);
            cache.put(format, rt);
        }
        return rt;
    }
}

