/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.main;

import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.casbin.jcasbin.main.Enforcer;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;

public class SyncedEnforcer
extends Enforcer {
    private static final ReadWriteLock READ_WRITE_LOCK = new ReentrantReadWriteLock();

    public SyncedEnforcer() {
    }

    public SyncedEnforcer(String modelPath, String policyFile) {
        super(modelPath, policyFile);
    }

    public SyncedEnforcer(String modelPath, Adapter adapter) {
        super(modelPath, adapter);
    }

    public SyncedEnforcer(Model m, Adapter adapter) {
        super(m, adapter);
    }

    public SyncedEnforcer(Model m) {
        super(m);
    }

    public SyncedEnforcer(String modelPath) {
        super(modelPath);
    }

    public SyncedEnforcer(String modelPath, String policyFile, boolean enableLog) {
        super(modelPath, policyFile, enableLog);
    }

    @Override
    public List<String> getRolesForUser(String name) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<String> list = super.getRolesForUser(name);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public List<String> getUsersForRole(String name) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<String> list = super.getUsersForRole(name);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRoleForUser(String name, String role) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            boolean bl = super.hasRoleForUser(name, role);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRoleForUser(String user, String role) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addRoleForUser(user, role);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteRoleForUser(String user, String role) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deleteRoleForUser(user, role);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean deleteRolesForUser(String user) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deleteRolesForUser(user);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean deleteUser(String user) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deleteUser(user);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public void deleteRole(String role) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            super.deleteRole(role);
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean deletePermission(String ... permission) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deletePermission(permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean deletePermission(List<String> permission) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deletePermission(permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPermissionForUser(String user, String ... permission) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addPermissionForUser(user, permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPermissionForUser(String user, List<String> permission) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addPermissionForUser(user, permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletePermissionForUser(String user, String ... permission) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deletePermissionForUser(user, permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletePermissionForUser(String user, List<String> permission) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deletePermissionForUser(user, permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean deletePermissionsForUser(String user) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deletePermissionsForUser(user);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public List<List<String>> getPermissionsForUser(String user) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<List<String>> list = super.getPermissionsForUser(user);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPermissionForUser(String user, String ... permission) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            boolean bl = super.hasPermissionForUser(user, permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPermissionForUser(String user, List<String> permission) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            boolean bl = super.hasPermissionForUser(user, permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getRolesForUserInDomain(String name, String domain) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<String> list = super.getRolesForUserInDomain(name, domain);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<List<String>> getPermissionsForUserInDomain(String user, String domain) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<List<String>> list = super.getPermissionsForUserInDomain(user, domain);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRoleForUserInDomain(String user, String role, String domain) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addRoleForUserInDomain(user, role, domain);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteRoleForUserInDomain(String user, String role, String domain) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deleteRoleForUserInDomain(user, role, domain);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getImplicitRolesForUser(String name, String ... domain) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<String> list = super.getImplicitRolesForUser(name, domain);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public List<List<String>> getImplicitPermissionsForUser(String user) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<List<String>> list = super.getImplicitPermissionsForUser(user);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }
}

