/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.core.InternalCache;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.impl.config.copy.DefaultCopierConfiguration;
import org.ehcache.impl.config.copy.DefaultCopyProviderConfiguration;
import org.ehcache.impl.config.loaderwriter.DefaultCacheLoaderWriterConfiguration;
import org.ehcache.impl.copy.SerializingCopier;
import org.ehcache.impl.internal.classes.ClassInstanceConfiguration;
import org.ehcache.jsr107.CacheResources;
import org.ehcache.jsr107.Eh107CacheLoaderWriter;
import org.ehcache.jsr107.Eh107CacheLoaderWriterProvider;
import org.ehcache.jsr107.Eh107CompleteConfiguration;
import org.ehcache.jsr107.Eh107Configuration;
import org.ehcache.jsr107.Eh107Expiry;
import org.ehcache.jsr107.Eh107IdentityCopier;
import org.ehcache.jsr107.EhcacheExpiryWrapper;
import org.ehcache.jsr107.ExpiryPolicyToEhcacheExpiry;
import org.ehcache.jsr107.ListenerResources;
import org.ehcache.jsr107.MultiCacheException;
import org.ehcache.jsr107.config.ConfigurationElementState;
import org.ehcache.jsr107.config.Jsr107CacheConfiguration;
import org.ehcache.jsr107.config.Jsr107Service;
import org.ehcache.jsr107.internal.Jsr107CacheLoaderWriter;
import org.ehcache.spi.copy.Copier;
import org.ehcache.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationMerger {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationMerger.class);
    private final XmlConfiguration xmlConfiguration;
    private final Jsr107Service jsr107Service;
    private final Eh107CacheLoaderWriterProvider cacheLoaderWriterFactory;

    ConfigurationMerger(Configuration ehConfig, Jsr107Service jsr107Service, Eh107CacheLoaderWriterProvider cacheLoaderWriterFactory) {
        this.xmlConfiguration = ehConfig instanceof XmlConfiguration ? (XmlConfiguration)ehConfig : null;
        this.jsr107Service = jsr107Service;
        this.cacheLoaderWriterFactory = cacheLoaderWriterFactory;
    }

    <K, V> ConfigHolder<K, V> mergeConfigurations(String cacheName, javax.cache.configuration.Configuration<K, V> configuration) {
        Eh107CompleteConfiguration<K, V> jsr107Configuration = new Eh107CompleteConfiguration<K, V>(configuration);
        Eh107Expiry<K, V> expiryPolicy = null;
        Jsr107CacheLoaderWriter<K, V> loaderWriter = null;
        try {
            boolean useEhcacheLoaderWriter;
            boolean hasConfiguredExpiry;
            CacheConfigurationBuilder<K, V> builder = CacheConfigurationBuilder.newCacheConfigurationBuilder(configuration.getKeyType(), configuration.getValueType(), ResourcePoolsBuilder.heap(Long.MAX_VALUE));
            String templateName = this.jsr107Service.getTemplateNameForCache(cacheName);
            if (this.xmlConfiguration != null && templateName != null) {
                CacheConfigurationBuilder<K, V> templateBuilder;
                try {
                    templateBuilder = this.xmlConfiguration.newCacheConfigurationBuilderFromTemplate(templateName, jsr107Configuration.getKeyType(), jsr107Configuration.getValueType());
                }
                catch (IllegalStateException e) {
                    templateBuilder = this.xmlConfiguration.newCacheConfigurationBuilderFromTemplate(templateName, jsr107Configuration.getKeyType(), jsr107Configuration.getValueType(), ResourcePoolsBuilder.heap(Long.MAX_VALUE));
                }
                if (templateBuilder != null) {
                    builder = templateBuilder;
                    LOG.info("Configuration of cache {} will be supplemented by template {}", (Object)cacheName, (Object)templateName);
                }
            }
            if (hasConfiguredExpiry = (builder = this.handleStoreByValue(jsr107Configuration, builder, cacheName)).hasConfiguredExpiry()) {
                LOG.info("Cache {} will use expiry configuration from template {}", (Object)cacheName, (Object)templateName);
            } else {
                expiryPolicy = this.initExpiryPolicy(jsr107Configuration);
                builder = builder.withExpiry(expiryPolicy);
            }
            DefaultCacheLoaderWriterConfiguration ehcacheLoaderWriterConfiguration = builder.getExistingServiceConfiguration(DefaultCacheLoaderWriterConfiguration.class);
            if (ehcacheLoaderWriterConfiguration == null) {
                useEhcacheLoaderWriter = false;
                loaderWriter = this.initCacheLoaderWriter(jsr107Configuration, new MultiCacheException());
                if (loaderWriter != null && (jsr107Configuration.isReadThrough() || jsr107Configuration.isWriteThrough())) {
                    this.cacheLoaderWriterFactory.registerJsr107Loader(cacheName, loaderWriter);
                }
            } else {
                useEhcacheLoaderWriter = true;
                if (!jsr107Configuration.isReadThrough() && !jsr107Configuration.isWriteThrough()) {
                    LOG.warn("Activating Ehcache loader/writer for JSR-107 cache {} which was neither read-through nor write-through", (Object)cacheName);
                }
                LOG.info("Cache {} will use loader/writer configuration from template {}", (Object)cacheName, (Object)templateName);
            }
            Object cacheConfiguration = builder.build();
            this.setupManagementAndStatsInternal(jsr107Configuration, ServiceUtils.findSingletonAmongst(Jsr107CacheConfiguration.class, cacheConfiguration.getServiceConfigurations()));
            if (hasConfiguredExpiry) {
                expiryPolicy = new EhcacheExpiryWrapper(cacheConfiguration.getExpiryPolicy());
            }
            return new ConfigHolder<K, V>(new CacheResources<K, V>(cacheName, loaderWriter, expiryPolicy, this.initCacheEventListeners(jsr107Configuration)), new Eh107CompleteConfiguration<K, V>(jsr107Configuration, cacheConfiguration, hasConfiguredExpiry, useEhcacheLoaderWriter), cacheConfiguration, useEhcacheLoaderWriter);
        }
        catch (Throwable throwable) {
            MultiCacheException mce = new MultiCacheException();
            CacheResources.close(expiryPolicy, mce);
            CacheResources.close(loaderWriter, mce);
            if (throwable instanceof IllegalArgumentException) {
                String message = throwable.getMessage();
                if (mce.getMessage() != null) {
                    message = message + "\nSuppressed " + mce.getMessage();
                }
                throw new IllegalArgumentException(message, throwable);
            }
            mce.addFirstThrowable(throwable);
            throw mce;
        }
    }

    private <K, V> CacheConfigurationBuilder<K, V> handleStoreByValue(Eh107CompleteConfiguration<K, V> jsr107Configuration, CacheConfigurationBuilder<K, V> builder, String cacheName) {
        DefaultCopierConfiguration copierConfig = builder.getExistingServiceConfiguration(DefaultCopierConfiguration.class);
        if (copierConfig == null) {
            if (jsr107Configuration.isStoreByValue()) {
                DefaultCopyProviderConfiguration defaultCopyProviderConfiguration;
                if (this.xmlConfiguration != null && (defaultCopyProviderConfiguration = ServiceUtils.findSingletonAmongst(DefaultCopyProviderConfiguration.class, this.xmlConfiguration.getServiceCreationConfigurations().toArray())) != null) {
                    Map<Class<?>, ClassInstanceConfiguration<Copier<?>>> defaults = defaultCopyProviderConfiguration.getDefaults();
                    ConfigurationMerger.handleCopierDefaultsforImmutableTypes(defaults);
                    boolean matchingDefault = false;
                    if (defaults.containsKey(jsr107Configuration.getKeyType())) {
                        matchingDefault = true;
                    } else {
                        builder = builder.add(new DefaultCopierConfiguration(SerializingCopier.asCopierClass(), DefaultCopierConfiguration.Type.KEY));
                    }
                    if (defaults.containsKey(jsr107Configuration.getValueType())) {
                        matchingDefault = true;
                    } else {
                        builder = builder.add(new DefaultCopierConfiguration(SerializingCopier.asCopierClass(), DefaultCopierConfiguration.Type.VALUE));
                    }
                    if (matchingDefault) {
                        LOG.info("CacheManager level copier configuration overwriting JSR-107 by-value semantics for cache {}", (Object)cacheName);
                    }
                    return builder;
                }
                builder = ConfigurationMerger.addDefaultCopiers(builder, jsr107Configuration.getKeyType(), jsr107Configuration.getValueType());
                LOG.debug("Using default Copier for JSR-107 store-by-value cache {}", (Object)cacheName);
            }
        } else {
            LOG.info("Cache level copier configuration overwriting JSR-107 by-value semantics for cache {}", (Object)cacheName);
        }
        return builder;
    }

    private static <K, V> CacheConfigurationBuilder<K, V> addDefaultCopiers(CacheConfigurationBuilder<K, V> builder, Class keyType, Class valueType) {
        HashSet<Class> immutableTypes = new HashSet<Class>();
        immutableTypes.add(String.class);
        immutableTypes.add(Long.class);
        immutableTypes.add(Float.class);
        immutableTypes.add(Double.class);
        immutableTypes.add(Character.class);
        immutableTypes.add(Integer.class);
        builder = immutableTypes.contains(keyType) ? builder.add(new DefaultCopierConfiguration(Eh107IdentityCopier.class, DefaultCopierConfiguration.Type.KEY)) : builder.add(new DefaultCopierConfiguration(SerializingCopier.asCopierClass(), DefaultCopierConfiguration.Type.KEY));
        builder = immutableTypes.contains(valueType) ? builder.add(new DefaultCopierConfiguration(Eh107IdentityCopier.class, DefaultCopierConfiguration.Type.VALUE)) : builder.add(new DefaultCopierConfiguration(SerializingCopier.asCopierClass(), DefaultCopierConfiguration.Type.VALUE));
        return builder;
    }

    private static void handleCopierDefaultsforImmutableTypes(Map<Class<?>, ClassInstanceConfiguration<Copier<?>>> defaults) {
        ConfigurationMerger.addIdentityCopierIfNoneRegistered(defaults, Long.class);
        ConfigurationMerger.addIdentityCopierIfNoneRegistered(defaults, Integer.class);
        ConfigurationMerger.addIdentityCopierIfNoneRegistered(defaults, String.class);
        ConfigurationMerger.addIdentityCopierIfNoneRegistered(defaults, Float.class);
        ConfigurationMerger.addIdentityCopierIfNoneRegistered(defaults, Double.class);
        ConfigurationMerger.addIdentityCopierIfNoneRegistered(defaults, Character.class);
    }

    private static void addIdentityCopierIfNoneRegistered(Map<Class<?>, ClassInstanceConfiguration<Copier<?>>> defaults, Class<?> clazz) {
        if (!defaults.containsKey(clazz)) {
            defaults.put(clazz, new DefaultCopierConfiguration(Eh107IdentityCopier.class, DefaultCopierConfiguration.Type.VALUE));
        }
    }

    private <K, V> Map<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>> initCacheEventListeners(CompleteConfiguration<K, V> config) {
        ConcurrentHashMap listenerResources = new ConcurrentHashMap();
        MultiCacheException mce = new MultiCacheException();
        for (CacheEntryListenerConfiguration listenerConfig : config.getCacheEntryListenerConfigurations()) {
            listenerResources.put(listenerConfig, ListenerResources.createListenerResources(listenerConfig, mce));
        }
        return listenerResources;
    }

    private <K, V> Eh107Expiry<K, V> initExpiryPolicy(CompleteConfiguration<K, V> config) {
        return new ExpiryPolicyToEhcacheExpiry((ExpiryPolicy)config.getExpiryPolicyFactory().create());
    }

    private <K, V> Jsr107CacheLoaderWriter<K, V> initCacheLoaderWriter(CompleteConfiguration<K, V> config, MultiCacheException mce) {
        CacheWriter cacheWriter;
        Factory cacheLoaderFactory = config.getCacheLoaderFactory();
        Factory cacheWriterFactory = config.getCacheWriterFactory();
        if (config.isReadThrough() && cacheLoaderFactory == null) {
            throw new IllegalArgumentException("read-through enabled without a CacheLoader factory provided");
        }
        if (config.isWriteThrough() && cacheWriterFactory == null) {
            throw new IllegalArgumentException("write-through enabled without a CacheWriter factory provided");
        }
        CacheLoader cacheLoader = cacheLoaderFactory == null ? null : (CacheLoader)cacheLoaderFactory.create();
        try {
            cacheWriter = cacheWriterFactory == null ? null : (CacheWriter)cacheWriterFactory.create();
        }
        catch (Throwable t) {
            if (t != mce) {
                mce.addThrowable(t);
            }
            CacheResources.close(cacheLoader, mce);
            throw mce;
        }
        if (cacheLoader == null && cacheWriter == null) {
            return null;
        }
        return new Eh107CacheLoaderWriter(cacheLoader, config.isReadThrough(), cacheWriter, config.isWriteThrough());
    }

    void setUpManagementAndStats(InternalCache<?, ?> cache, Eh107Configuration<?, ?> configuration) {
        Jsr107CacheConfiguration cacheConfiguration = ServiceUtils.findSingletonAmongst(Jsr107CacheConfiguration.class, cache.getRuntimeConfiguration().getServiceConfigurations());
        this.setupManagementAndStatsInternal(configuration, cacheConfiguration);
    }

    private void setupManagementAndStatsInternal(Eh107Configuration<?, ?> configuration, Jsr107CacheConfiguration cacheConfiguration) {
        ConfigurationElementState enableManagement = this.jsr107Service.isManagementEnabledOnAllCaches();
        ConfigurationElementState enableStatistics = this.jsr107Service.isStatisticsEnabledOnAllCaches();
        if (cacheConfiguration != null) {
            ConfigurationElementState statisticsEnabled;
            ConfigurationElementState managementEnabled = cacheConfiguration.isManagementEnabled();
            if (managementEnabled != null && managementEnabled != ConfigurationElementState.UNSPECIFIED) {
                enableManagement = managementEnabled;
            }
            if ((statisticsEnabled = cacheConfiguration.isStatisticsEnabled()) != null && statisticsEnabled != ConfigurationElementState.UNSPECIFIED) {
                enableStatistics = statisticsEnabled;
            }
        }
        if (enableManagement != null && enableManagement != ConfigurationElementState.UNSPECIFIED) {
            configuration.setManagementEnabled(enableManagement.asBoolean());
        }
        if (enableStatistics != null && enableStatistics != ConfigurationElementState.UNSPECIFIED) {
            configuration.setStatisticsEnabled(enableStatistics.asBoolean());
        }
    }

    static class ConfigHolder<K, V> {
        final CacheResources<K, V> cacheResources;
        final CacheConfiguration<K, V> cacheConfiguration;
        final Eh107CompleteConfiguration<K, V> jsr107Configuration;
        final boolean useEhcacheLoaderWriter;

        public ConfigHolder(CacheResources<K, V> cacheResources, Eh107CompleteConfiguration<K, V> jsr107Configuration, CacheConfiguration<K, V> cacheConfiguration, boolean useEhcacheLoaderWriter) {
            this.cacheResources = cacheResources;
            this.jsr107Configuration = jsr107Configuration;
            this.cacheConfiguration = cacheConfiguration;
            this.useEhcacheLoaderWriter = useEhcacheLoaderWriter;
        }
    }
}

