/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spi.service.contexts;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.HttpMethod;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.SecurityContextBuilder;

public class SecurityContext {
    private final List<SecurityReference> securityReferences;
    private final Predicate<String> selector;
    private final Predicate<HttpMethod> methodSelector;

    public SecurityContext(List<SecurityReference> securityReferences, Predicate<String> selector) {
        this.securityReferences = securityReferences;
        this.selector = selector;
        this.methodSelector = Predicates.alwaysTrue();
    }

    public SecurityContext(List<SecurityReference> securityReferences, Predicate<String> selector, Predicate<HttpMethod> methodSelector) {
        this.securityReferences = securityReferences;
        this.selector = selector;
        this.methodSelector = methodSelector;
    }

    @Deprecated
    public List<SecurityReference> securityForPath(String path) {
        if (this.selector.apply((Object)path)) {
            return this.securityReferences;
        }
        return new ArrayList<SecurityReference>();
    }

    public List<SecurityReference> securityForOperation(OperationContext operationContext) {
        if (this.selector.apply((Object)operationContext.requestMappingPattern()) && this.methodSelector.apply((Object)operationContext.httpMethod())) {
            return this.securityReferences;
        }
        return new ArrayList<SecurityReference>();
    }

    public List<SecurityReference> getSecurityReferences() {
        return this.securityReferences;
    }

    public Predicate<HttpMethod> getMethodSelector() {
        return this.methodSelector;
    }

    public static SecurityContextBuilder builder() {
        return new SecurityContextBuilder();
    }
}

