/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.utils.Env;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public abstract class BaseExpression
implements Expression {
    private List<String> varNames;
    private List<String> varFullNames;
    private String expression;
    protected AviatorEvaluatorInstance instance;
    private Env compileEnv;

    public BaseExpression(AviatorEvaluatorInstance instance, List<String> varNames) {
        this.varFullNames = varNames;
        this.instance = instance;
        LinkedHashSet<String> tmp = new LinkedHashSet<String>(varNames.size());
        for (String name : varNames) {
            if (name.contains(".")) {
                name = name.substring(0, name.indexOf("."));
            }
            tmp.add(name);
        }
        this.varNames = new ArrayList<String>(tmp);
    }

    public Env getCompileEnv() {
        return this.compileEnv;
    }

    public void setCompileEnv(Env compileEnv) {
        this.compileEnv = compileEnv;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public Object execute() {
        return this.execute(null);
    }

    @Override
    public List<String> getVariableFullNames() {
        return this.varFullNames;
    }

    @Override
    public List<String> getVariableNames() {
        return this.varNames;
    }

    protected Env newEnv(Map<String, Object> map, boolean direct) {
        Env env = direct ? new Env(map, map == Collections.EMPTY_MAP ? new HashMap() : map) : new Env(map);
        env.setInstance(this.instance);
        return env;
    }

    protected Env genTopEnv(Map<String, Object> map) {
        Env env = this.newEnv(map, this.instance.getOptionValue((Options)Options.USE_USER_ENV_AS_TOP_ENV_DIRECTLY).bool);
        if (this.compileEnv != null && !this.compileEnv.isEmpty()) {
            env.putAll((Map)this.compileEnv);
        }
        return env;
    }

    protected Env newEnv(Map<String, Object> map) {
        return this.newEnv(map, false);
    }
}

