/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.providers;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class WebConversionServiceProvider
implements InitializingBean,
ApplicationContextAware {
    private static final String CONVERTERS = "converters";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebConversionServiceProvider.class);
    private static final String SERVLET_APPLICATION_CONTEXT_CLASS = "org.springframework.web.context.WebApplicationContext";
    private static final String REACTIVE_APPLICATION_CONTEXT_CLASS = "org.springframework.boot.web.reactive.context.ReactiveWebApplicationContext";
    private GenericConversionService formattingConversionService;
    private ApplicationContext applicationContext;

    public void afterPropertiesSet() {
        this.formattingConversionService = this.isAssignable(SERVLET_APPLICATION_CONTEXT_CLASS, this.applicationContext.getClass()) ? (GenericConversionService)this.applicationContext.getBean("mvcConversionService", FormattingConversionService.class) : (this.isAssignable(REACTIVE_APPLICATION_CONTEXT_CLASS, this.applicationContext.getClass()) ? (GenericConversionService)this.applicationContext.getBean("webFluxConversionService", FormattingConversionService.class) : new DefaultFormattingConversionService());
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor targetTypeDescriptor) {
        return this.formattingConversionService.convert(source, targetTypeDescriptor);
    }

    public Class<?> getSpringConvertedType(Class<?> clazz) {
        Class result = clazz;
        Field convertersField = FieldUtils.getDeclaredField(GenericConversionService.class, (String)CONVERTERS, (boolean)true);
        if (convertersField != null) {
            try {
                Object converters = convertersField.get(this.formattingConversionService);
                convertersField = FieldUtils.getDeclaredField(converters.getClass(), (String)CONVERTERS, (boolean)true);
                Map springConverters = (Map)convertersField.get(converters);
                Optional<GenericConverter.ConvertiblePair> convertiblePairOptional = springConverters.keySet().stream().filter(convertiblePair -> convertiblePair.getTargetType().equals(clazz)).findAny();
                if (convertiblePairOptional.isPresent()) {
                    GenericConverter.ConvertiblePair convertiblePair2 = convertiblePairOptional.get();
                    result = convertiblePair2.getSourceType();
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        return result;
    }

    private boolean isAssignable(String target, Class<?> type) {
        try {
            return ClassUtils.resolveClassName((String)target, null).isAssignableFrom(type);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

