/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.internal.resilience;

import java.util.Map;
import java.util.Objects;
import org.ehcache.core.exceptions.ExceptionFactory;
import org.ehcache.core.internal.resilience.AbstractResilienceStrategy;
import org.ehcache.spi.loaderwriter.BulkCacheLoadingException;
import org.ehcache.spi.loaderwriter.BulkCacheWritingException;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.resilience.RecoveryStore;
import org.ehcache.spi.resilience.StoreAccessException;

public class RobustLoaderWriterResilienceStrategy<K, V>
extends AbstractResilienceStrategy<K, V> {
    private final CacheLoaderWriter<? super K, V> loaderWriter;

    public RobustLoaderWriterResilienceStrategy(RecoveryStore<K> store, CacheLoaderWriter<? super K, V> loaderWriter) {
        super(store);
        this.loaderWriter = Objects.requireNonNull(loaderWriter);
    }

    @Override
    public V getFailure(K key, StoreAccessException e) {
        try {
            V v = this.loaderWriter.load(key);
            return v;
        }
        catch (Exception e1) {
            throw ExceptionFactory.newCacheLoadingException(e1, e);
        }
        finally {
            this.cleanup(key, e);
        }
    }

    @Override
    public boolean containsKeyFailure(K key, StoreAccessException e) {
        this.cleanup(key, e);
        return false;
    }

    @Override
    public void putFailure(K key, V value, StoreAccessException e) {
        try {
            this.loaderWriter.write(key, value);
        }
        catch (Exception e1) {
            throw ExceptionFactory.newCacheWritingException(e1, e);
        }
        finally {
            this.cleanup(key, e);
        }
    }

    @Override
    public void removeFailure(K key, StoreAccessException e) {
        try {
            this.loaderWriter.delete(key);
        }
        catch (Exception e1) {
            throw ExceptionFactory.newCacheWritingException(e1, e);
        }
        finally {
            this.cleanup(key, e);
        }
    }

    @Override
    public void clearFailure(StoreAccessException e) {
        this.cleanup(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V putIfAbsentFailure(K key, V value, StoreAccessException e) {
        try {
            V loaded = this.loaderWriter.load(key);
            if (loaded != null) {
                V v = loaded;
                return v;
            }
            try {
                this.loaderWriter.write(key, value);
                return null;
            }
            catch (Exception e1) {
                throw ExceptionFactory.newCacheWritingException(e1, e);
            }
        }
        catch (Exception e1) {
            throw ExceptionFactory.newCacheLoadingException(e1, e);
        }
        finally {
            this.cleanup(key, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFailure(K key, V value, StoreAccessException e) {
        try {
            V loadedValue;
            try {
                loadedValue = this.loaderWriter.load(key);
            }
            catch (Exception e1) {
                throw ExceptionFactory.newCacheLoadingException(e1, e);
            }
            if (loadedValue == null) {
                boolean e1 = false;
                return e1;
            }
            if (!loadedValue.equals(value)) {
                boolean e1 = false;
                return e1;
            }
            try {
                this.loaderWriter.delete(key);
            }
            catch (Exception e1) {
                throw ExceptionFactory.newCacheWritingException(e1, e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.cleanup(key, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replaceFailure(K key, V value, StoreAccessException e) {
        try {
            V oldValue;
            try {
                oldValue = this.loaderWriter.load(key);
            }
            catch (Exception e1) {
                throw ExceptionFactory.newCacheLoadingException(e1, e);
            }
            if (oldValue != null) {
                try {
                    this.loaderWriter.write(key, value);
                }
                catch (Exception e1) {
                    throw ExceptionFactory.newCacheWritingException(e1, e);
                }
            }
            V v = oldValue;
            return v;
        }
        finally {
            this.cleanup(key, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceFailure(K key, V value, V newValue, StoreAccessException e) {
        try {
            V oldValue;
            try {
                oldValue = this.loaderWriter.load(key);
            }
            catch (Exception e1) {
                throw ExceptionFactory.newCacheLoadingException(e1, e);
            }
            if (oldValue != null && oldValue.equals(value)) {
                try {
                    this.loaderWriter.write(key, newValue);
                    boolean e1 = true;
                    return e1;
                }
                catch (Exception e1) {
                    throw ExceptionFactory.newCacheWritingException(e1, e);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.cleanup(key, e);
        }
    }

    @Override
    public Map<K, V> getAllFailure(Iterable<? extends K> keys, StoreAccessException e) {
        try {
            Map<? extends K, V> map = this.loaderWriter.loadAll(keys);
            return map;
        }
        catch (BulkCacheLoadingException e1) {
            throw e1;
        }
        catch (Exception e1) {
            throw ExceptionFactory.newCacheLoadingException(e1, e);
        }
        finally {
            this.cleanup(keys, e);
        }
    }

    @Override
    public void putAllFailure(Map<? extends K, ? extends V> entries, StoreAccessException e) {
        try {
            this.loaderWriter.writeAll(entries.entrySet());
        }
        catch (BulkCacheWritingException e1) {
            throw e1;
        }
        catch (Exception e1) {
            throw ExceptionFactory.newCacheWritingException(e1, e);
        }
        finally {
            this.cleanup(entries.keySet(), e);
        }
    }

    @Override
    public void removeAllFailure(Iterable<? extends K> keys, StoreAccessException e) {
        try {
            this.loaderWriter.deleteAll(keys);
        }
        catch (BulkCacheWritingException e1) {
            throw e1;
        }
        catch (Exception e1) {
            throw ExceptionFactory.newCacheWritingException(e1, e);
        }
        finally {
            this.cleanup(keys, e);
        }
    }
}

