/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.envers.ModificationStore;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditedPropertiesHolder;
import org.hibernate.envers.configuration.internal.metadata.reader.ClassAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.EnversMessageLogger;
import org.hibernate.envers.internal.tools.MappingTools;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.List;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;
import org.jboss.logging.Logger;

public class ClassesAuditingData {
    private static final EnversMessageLogger LOG = (EnversMessageLogger)Logger.getMessageLogger(EnversMessageLogger.class, (String)ClassesAuditingData.class.getName());
    private final Map<String, ClassAuditingData> entityNameToAuditingData = new HashMap<String, ClassAuditingData>();
    private final Map<PersistentClass, ClassAuditingData> persistentClassToAuditingData = new LinkedHashMap<PersistentClass, ClassAuditingData>();

    public void addClassAuditingData(PersistentClass pc, ClassAuditingData cad) {
        this.entityNameToAuditingData.put(pc.getEntityName(), cad);
        this.persistentClassToAuditingData.put(pc, cad);
    }

    public Collection<Map.Entry<PersistentClass, ClassAuditingData>> getAllClassAuditedData() {
        return this.persistentClassToAuditingData.entrySet();
    }

    public ClassAuditingData getClassAuditingData(String entityName) {
        return this.entityNameToAuditingData.get(entityName);
    }

    public void updateCalculatedFields() {
        for (Map.Entry<PersistentClass, ClassAuditingData> classAuditingDataEntry : this.persistentClassToAuditingData.entrySet()) {
            PersistentClass pc = classAuditingDataEntry.getKey();
            ClassAuditingData classAuditingData = classAuditingDataEntry.getValue();
            for (String propertyName : classAuditingData.getNonSyntheticPropertyNames()) {
                Property property = pc.getProperty(propertyName);
                this.updateCalculatedProperty(pc.getEntityName(), property, propertyName, classAuditingData);
            }
        }
    }

    private void updateCalculatedProperty(String entityName, Property property, String propertyName, AuditedPropertiesHolder propertyHolder) {
        boolean isRelationMappedBy;
        PropertyAuditingData propertyAuditingData = propertyHolder.getPropertyAuditingData(propertyName);
        boolean isAuditMappedBy = propertyAuditingData.getAuditMappedBy() != null;
        boolean bl = isRelationMappedBy = propertyAuditingData.getRelationMappedBy() != null;
        if (isAuditMappedBy || isRelationMappedBy) {
            String referencedEntityName = MappingTools.getReferencedEntityName(property.getValue());
            ClassAuditingData referencedAuditData = this.entityNameToAuditingData.get(referencedEntityName);
            if (isAuditMappedBy) {
                this.setAuditMappedByInsertable(referencedEntityName, entityName, referencedAuditData, propertyAuditingData);
            } else if (isRelationMappedBy && property.getValue() instanceof List) {
                this.addSyntheticIndexProperty((List)property.getValue(), property.getPropertyAccessorName(), referencedAuditData);
            }
        }
        if (propertyAuditingData instanceof ComponentAuditingData) {
            ComponentAuditingData componentAuditingData = (ComponentAuditingData)propertyAuditingData;
            Component component = (Component)property.getValue();
            for (String componentPropertyName : componentAuditingData.getNonSyntheticPropertyNames()) {
                Property componentProperty = component.getProperty(componentPropertyName);
                this.updateCalculatedProperty(entityName, componentProperty, componentPropertyName, componentAuditingData);
            }
        }
    }

    private void setAuditMappedByInsertable(String referencedEntityName, String entityName, ClassAuditingData referencedAuditData, PropertyAuditingData propertyAuditingData) {
        this.forcePropertyInsertable(referencedAuditData, propertyAuditingData.getAuditMappedBy(), entityName, referencedEntityName);
        this.forcePropertyInsertable(referencedAuditData, propertyAuditingData.getPositionMappedBy(), entityName, referencedEntityName);
    }

    private void addSyntheticIndexProperty(List value, String propertyAccessorName, ClassAuditingData classAuditingData) {
        String indexColumnName;
        Value indexValue = value.getIndex();
        if (indexValue != null && indexValue.getColumnIterator().hasNext() && (indexColumnName = ((Selectable)indexValue.getColumnIterator().next()).getText()) != null) {
            PropertyAuditingData auditingData = new PropertyAuditingData(indexColumnName, propertyAccessorName, ModificationStore.FULL, RelationTargetAuditMode.AUDITED, null, null, false, true, indexValue);
            classAuditingData.addPropertyAuditingData(indexColumnName, auditingData);
        }
    }

    private void forcePropertyInsertable(ClassAuditingData classAuditingData, String propertyName, String entityName, String referencedEntityName) {
        if (propertyName != null) {
            if (classAuditingData.getPropertyAuditingData(propertyName) == null) {
                throw new MappingException("@AuditMappedBy points to a property that doesn't exist: " + referencedEntityName + "." + propertyName);
            }
            LOG.debugf("Non-insertable property %s.%s will be made insertable because a matching @AuditMappedBy was found in the %s entity", referencedEntityName, propertyName, entityName);
            classAuditingData.getPropertyAuditingData(propertyName).setForceInsertable(true);
        }
    }
}

