/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.HashMap;
import java.util.Map;
import org.apiguardian.api.API;
import org.zalando.problem.AbstractThrowableProblemMixIn;
import org.zalando.problem.DefaultProblem;
import org.zalando.problem.Exceptional;
import org.zalando.problem.ExceptionalMixin;
import org.zalando.problem.ExceptionalWithoutStacktraceMixin;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemMixIn;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.StatusTypeDeserializer;
import org.zalando.problem.StatusTypeSerializer;

@API(status=API.Status.STABLE)
public final class ProblemModule
extends Module {
    private final boolean stackTraces;
    private final Map<Integer, StatusType> statuses;

    public ProblemModule() {
        this(Status.class);
    }

    @SafeVarargs
    public <E extends Enum> ProblemModule(Class<? extends E> ... types) throws IllegalArgumentException {
        this(false, ProblemModule.buildIndex(types));
    }

    private ProblemModule(boolean stackTraces, Map<Integer, StatusType> statuses) {
        this.stackTraces = stackTraces;
        this.statuses = statuses;
    }

    public String getModuleName() {
        return ProblemModule.class.getSimpleName();
    }

    public Version version() {
        return VersionUtil.mavenVersionFor((ClassLoader)ProblemModule.class.getClassLoader(), (String)"org.zalando", (String)"jackson-datatype-problem");
    }

    public void setupModule(Module.SetupContext context) {
        SimpleModule module = new SimpleModule();
        module.setMixInAnnotation(Exceptional.class, this.stackTraces ? ExceptionalMixin.class : ExceptionalWithoutStacktraceMixin.class);
        module.setMixInAnnotation(DefaultProblem.class, AbstractThrowableProblemMixIn.class);
        module.setMixInAnnotation(Problem.class, ProblemMixIn.class);
        module.addSerializer(StatusType.class, (JsonSerializer)new StatusTypeSerializer());
        module.addDeserializer(StatusType.class, (JsonDeserializer)new StatusTypeDeserializer(this.statuses));
        module.setupModule(context);
    }

    @SafeVarargs
    private static <E extends Enum> Map<Integer, StatusType> buildIndex(Class<? extends E> ... types) {
        HashMap<Integer, StatusType> index = new HashMap<Integer, StatusType>();
        for (Class<E> clazz : types) {
            for (Enum status : (Enum[])clazz.getEnumConstants()) {
                if (index.containsKey(((StatusType)status).getStatusCode())) {
                    throw new IllegalArgumentException("Duplicate status codes are not allowed");
                }
                index.put(((StatusType)status).getStatusCode(), (StatusType)status);
            }
        }
        return index;
    }

    public ProblemModule withStackTraces() {
        return this.withStackTraces(true);
    }

    public ProblemModule withStackTraces(boolean stackTraces) {
        return new ProblemModule(stackTraces, this.statuses);
    }
}

