/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.SelectionSet;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

public class CustomRepositoryImplementationDetector {
    private static final String CUSTOM_IMPLEMENTATION_RESOURCE_PATTERN = "**/%s.class";
    private static final String AMBIGUOUS_CUSTOM_IMPLEMENTATIONS = "Ambiguous custom implementations detected! Found %s but expected a single implementation!";
    @NonNull
    private final MetadataReaderFactory metadataReaderFactory;
    @NonNull
    private final Environment environment;
    @NonNull
    private final ResourceLoader resourceLoader;

    public Optional<AbstractBeanDefinition> detectCustomImplementation(RepositoryConfiguration<?> configuration) {
        return this.detectCustomImplementation(configuration.getImplementationClassName(), configuration.getImplementationBeanName(), configuration.getImplementationBasePackages(), configuration.getExcludeFilters(), bd -> configuration.getConfigurationSource().generateBeanName((BeanDefinition)bd));
    }

    public Optional<AbstractBeanDefinition> detectCustomImplementation(String className, @Nullable String beanName, Iterable<String> basePackages, Iterable<TypeFilter> excludeFilters, Function<BeanDefinition, String> beanNameGenerator) {
        Assert.notNull((Object)className, (String)"ClassName must not be null!");
        Assert.notNull(basePackages, (String)"BasePackages must not be null!");
        Set<BeanDefinition> definitions = this.findCandidateBeanDefinitions(className, basePackages, excludeFilters);
        return SelectionSet.of(definitions, c -> c.isEmpty() ? Optional.empty() : CustomRepositoryImplementationDetector.throwAmbiguousCustomImplementationException(c)).filterIfNecessary(bd -> beanName != null && beanName.equals(beanNameGenerator.apply((BeanDefinition)bd))).uniqueResult().map(it -> (AbstractBeanDefinition)AbstractBeanDefinition.class.cast(it));
    }

    Set<BeanDefinition> findCandidateBeanDefinitions(String className, Iterable<String> basePackages, Iterable<TypeFilter> excludeFilters) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false, this.environment);
        provider.setResourceLoader(this.resourceLoader);
        provider.setResourcePattern(String.format(CUSTOM_IMPLEMENTATION_RESOURCE_PATTERN, className));
        provider.setMetadataReaderFactory(this.metadataReaderFactory);
        provider.addIncludeFilter((reader, factory) -> true);
        excludeFilters.forEach(it -> provider.addExcludeFilter(it));
        return Streamable.of(basePackages).stream().flatMap(it -> provider.findCandidateComponents(it).stream()).collect(Collectors.toSet());
    }

    private static Optional<BeanDefinition> throwAmbiguousCustomImplementationException(Collection<BeanDefinition> definitions) {
        String implementationNames = definitions.stream().map(BeanDefinition::getBeanClassName).collect(Collectors.joining(", "));
        throw new IllegalStateException(String.format(AMBIGUOUS_CUSTOM_IMPLEMENTATIONS, implementationNames));
    }

    public CustomRepositoryImplementationDetector(@NonNull MetadataReaderFactory metadataReaderFactory, @NonNull Environment environment, @NonNull ResourceLoader resourceLoader) {
        if (metadataReaderFactory == null) {
            throw new IllegalArgumentException("metadataReaderFactory is marked @NonNull but is null");
        }
        if (environment == null) {
            throw new IllegalArgumentException("environment is marked @NonNull but is null");
        }
        if (resourceLoader == null) {
            throw new IllegalArgumentException("resourceLoader is marked @NonNull but is null");
        }
        this.metadataReaderFactory = metadataReaderFactory;
        this.environment = environment;
        this.resourceLoader = resourceLoader;
    }
}

