CREATE TABLE tb_code
(
    id            bigint       not null auto_increment,
    tb_crop_id    bigint       not null,
    code          varchar(255),
    quantity      int,
    description   varchar(255),
    path_image    varchar(255),
    status        varchar(255) NOT NULL,
    expired_date  timestamp,
    created_date  timestamp,
    modified_date timestamp,
    deleted_date  timestamp,
    created_by    bigint,
    modified_by   bigint,
    deleted_by    bigint,
    PRIMARY KEY (id),
    CONSTRAINT ux_tb_code_code UNIQUE (code),
    CONSTRAINT fk_tb_code_tb_crop_id FOREIGN KEY (tb_crop_id)
        REFERENCES tb_crop (id),
    CONSTRAINT fk_tb_code_created_by_id FOREIGN KEY (created_by)
        REFERENCES tb_detail_user (id),
    CONSTRAINT fk_tb_code_modified_by_id FOREIGN KEY (modified_by)
        REFERENCES tb_detail_user (id),
    CONSTRAINT fk_tb_code_deleted_by_id FOREIGN KEY (deleted_by)
        REFERENCES tb_detail_user (id)
);

CREATE TABLE tb_code_details
(
    id                bigint not null auto_increment,
    tb_code_id        bigint not null,
    code              varchar(255),
    number_scan       int,
    status            varchar(255),
    last_updated_date timestamp,
    created_date      timestamp,
    modified_date     timestamp,
    deleted_date      timestamp,
    created_by        bigint,
    modified_by       bigint,
    deleted_by        bigint,
    PRIMARY KEY (id),
    CONSTRAINT ux_tb_code_details_code UNIQUE (tb_code_id, code),
    CONSTRAINT fk_tb_code_details_tb_code_id FOREIGN KEY (tb_code_id)
        REFERENCES tb_code (id),
    CONSTRAINT fk_tb_code_details_created_by_id FOREIGN KEY (created_by)
        REFERENCES tb_detail_user (id),
    CONSTRAINT fk_tb_code_details_modified_by_id FOREIGN KEY (modified_by)
        REFERENCES tb_detail_user (id),
    CONSTRAINT fk_tb_code_details_deleted_by_id FOREIGN KEY (deleted_by)
        REFERENCES tb_detail_user (id)
);

ALTER TABLE tb_activity_type
    ADD is_after_harvest bit NOT NULL default 0;

