/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class SeqIncludeFunction
extends AbstractFunction {
    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        Object first = arg1.getValue(env);
        if (first == null) {
            throw new NullPointerException("null seq");
        }
        Class<?> clazz = first.getClass();
        boolean contains = false;
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection seq = (Collection)first;
            try {
                for (Object obj : seq) {
                    if (new AviatorRuntimeJavaType(obj).compare(arg2, env) != 0) continue;
                    contains = true;
                }
            }
            catch (Exception e) {
                return AviatorBoolean.FALSE;
            }
        } else if (clazz.isArray()) {
            try {
                int length = Array.getLength(first);
                for (int i = 0; i < length; ++i) {
                    Object obj = Array.get(first, i);
                    if (new AviatorRuntimeJavaType(obj).compare(arg2, env) != 0) continue;
                    contains = true;
                }
            }
            catch (Exception e) {
                return AviatorBoolean.FALSE;
            }
        } else {
            throw new IllegalArgumentException(arg1.desc(env) + " is not a seq collection");
        }
        return AviatorBoolean.valueOf(contains);
    }

    @Override
    public String getName() {
        return "include";
    }
}

