/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorString;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.TypeUtils;
import java.util.Map;

public class AviatorBoolean
extends AviatorObject {
    Boolean value;
    public static final AviatorBoolean TRUE = new AviatorBoolean(Boolean.TRUE);
    public static final AviatorBoolean FALSE = new AviatorBoolean(Boolean.FALSE);

    @Override
    public AviatorObject not(Map<String, Object> env) {
        return this.value != false ? FALSE : TRUE;
    }

    @Override
    public final boolean booleanValue(Map<String, Object> env) {
        return this.value;
    }

    @Override
    public AviatorObject add(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case String: {
                return new AviatorString(this.value.toString() + ((AviatorString)other).lexeme);
            }
            case JavaType: {
                AviatorJavaType javaType = (AviatorJavaType)other;
                Object otherJavaValue = javaType.getValue(env);
                if (TypeUtils.isString(otherJavaValue)) {
                    return new AviatorString(this.value.toString() + otherJavaValue.toString());
                }
                return super.add(other, env);
            }
        }
        return super.add(other, env);
    }

    @Override
    public AviatorType getAviatorType() {
        return AviatorType.Boolean;
    }

    @Override
    public final Object getValue(Map<String, Object> env) {
        return this.value;
    }

    private AviatorBoolean(Boolean value) {
        this.value = value;
    }

    public static AviatorBoolean valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    @Override
    public int compare(AviatorObject other, Map<String, Object> env) {
        if (this == other) {
            return 0;
        }
        switch (other.getAviatorType()) {
            case Boolean: {
                AviatorBoolean otherBoolean = (AviatorBoolean)other;
                return this.value.compareTo(otherBoolean.value);
            }
            case JavaType: {
                AviatorJavaType javaType = (AviatorJavaType)other;
                Object otherValue = javaType.getValue(env);
                if (otherValue == null) {
                    return 1;
                }
                if (otherValue instanceof Boolean) {
                    return this.value.compareTo((Boolean)otherValue);
                }
                throw new ExpressionRuntimeException("Could not compare " + this.desc(env) + " with " + other.desc(env));
            }
            case Nil: {
                return 1;
            }
        }
        throw new ExpressionRuntimeException("Could not compare " + this.desc(env) + " with " + other.desc(env));
    }
}

