/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.collection;

import com.google.api.core.InternalApi;
import com.google.cloud.firestore.collection.ArraySortedMap;
import com.google.cloud.firestore.collection.LLRBNode;
import com.google.cloud.firestore.collection.RBTreeSortedMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@InternalApi
public abstract class ImmutableSortedMap<K, V>
implements Iterable<Map.Entry<K, V>> {
    public abstract boolean containsKey(K var1);

    public abstract V get(K var1);

    public abstract ImmutableSortedMap<K, V> remove(K var1);

    public abstract ImmutableSortedMap<K, V> insert(K var1, V var2);

    public abstract K getMinKey();

    public abstract K getMaxKey();

    public abstract int size();

    public abstract boolean isEmpty();

    public abstract void inOrderTraversal(LLRBNode.NodeVisitor<K, V> var1);

    @Override
    public abstract Iterator<Map.Entry<K, V>> iterator();

    public abstract Iterator<Map.Entry<K, V>> iteratorFrom(K var1);

    public abstract Iterator<Map.Entry<K, V>> reverseIteratorFrom(K var1);

    public abstract Iterator<Map.Entry<K, V>> reverseIterator();

    public abstract K getPredecessorKey(K var1);

    public abstract K getSuccessorKey(K var1);

    public abstract int indexOf(K var1);

    public abstract Comparator<K> getComparator();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableSortedMap)) {
            return false;
        }
        ImmutableSortedMap that = (ImmutableSortedMap)o;
        if (!this.getComparator().equals(that.getComparator())) {
            return false;
        }
        if (this.size() != that.size()) {
            return false;
        }
        Iterator<Map.Entry<K, V>> thisIterator = this.iterator();
        Iterator<Map.Entry<K, V>> thatIterator = that.iterator();
        while (thisIterator.hasNext()) {
            if (thisIterator.next().equals(thatIterator.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.getComparator().hashCode();
        for (Map.Entry<K, V> entry : this) {
            result = 31 * result + entry.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append("{");
        boolean first = true;
        for (Map.Entry<K, V> entry : this) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append("(");
            b.append(entry.getKey());
            b.append("=>");
            b.append(entry.getValue());
            b.append(")");
        }
        b.append("};");
        return b.toString();
    }

    public static class Builder {
        static final int ARRAY_TO_RB_TREE_SIZE_THRESHOLD = 25;
        private static final KeyTranslator IDENTITY_TRANSLATOR = new KeyTranslator(){

            public Object translate(Object key) {
                return key;
            }
        };

        public static <K, V> ImmutableSortedMap<K, V> emptyMap(Comparator<K> comparator) {
            return new ArraySortedMap(comparator);
        }

        public static <A> KeyTranslator<A, A> identityTranslator() {
            return IDENTITY_TRANSLATOR;
        }

        public static <A, B> ImmutableSortedMap<A, B> fromMap(Map<A, B> values, Comparator<A> comparator) {
            if (values.size() < 25) {
                return ArraySortedMap.fromMap(values, comparator);
            }
            return RBTreeSortedMap.fromMap(values, comparator);
        }

        public static <A, B, C> ImmutableSortedMap<A, C> buildFrom(List<A> keys, Map<B, C> values, KeyTranslator<A, B> translator, Comparator<A> comparator) {
            if (keys.size() < 25) {
                return ArraySortedMap.buildFrom(keys, values, translator, comparator);
            }
            return RBTreeSortedMap.buildFrom(keys, values, translator, comparator);
        }

        public static interface KeyTranslator<C, D> {
            public D translate(C var1);
        }
    }
}

