/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.breaker;

import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.unit.ByteSizeValue;

public class BreakerSettings {
    private final String name;
    private final long limitBytes;
    private final double overhead;
    private final CircuitBreaker.Type type;

    public BreakerSettings(String name, long limitBytes, double overhead) {
        this(name, limitBytes, overhead, CircuitBreaker.Type.MEMORY);
    }

    public BreakerSettings(String name, long limitBytes, double overhead, CircuitBreaker.Type type) {
        this.name = name;
        this.limitBytes = limitBytes;
        this.overhead = overhead;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public long getLimit() {
        return this.limitBytes;
    }

    public double getOverhead() {
        return this.overhead;
    }

    public CircuitBreaker.Type getType() {
        return this.type;
    }

    public String toString() {
        return "[" + this.name + ",type=" + this.type.toString() + ",limit=" + this.limitBytes + "/" + new ByteSizeValue(this.limitBytes) + ",overhead=" + this.overhead + "]";
    }
}

