/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.cloud.service.ServiceConnectorCreator;
import org.springframework.cloud.service.ServiceInfo;

public abstract class AbstractServiceConnectorCreator<SC, SI extends ServiceInfo>
implements ServiceConnectorCreator<SC, SI> {
    private Class<SC> connectorType;
    private Class<SI> serviceInfoType;

    public AbstractServiceConnectorCreator() {
        for (Class<?> clazz = this.getClass(); clazz != AbstractServiceConnectorCreator.class; clazz = clazz.getSuperclass()) {
            Type[] typeArgs;
            if (!(clazz.getGenericSuperclass() instanceof ParameterizedType)) continue;
            ParameterizedType genericSuperClass = (ParameterizedType)clazz.getGenericSuperclass();
            for (Type typeArg : typeArgs = genericSuperClass.getActualTypeArguments()) {
                if (!(typeArg instanceof Class)) continue;
                Class typeClass = (Class)typeArg;
                if (ServiceInfo.class.isAssignableFrom(typeClass)) {
                    this.serviceInfoType = typeClass;
                    continue;
                }
                this.connectorType = typeClass;
            }
        }
    }

    @Override
    public Class<SC> getServiceConnectorType() {
        return this.connectorType;
    }

    @Override
    public Class<SI> getServiceInfoType() {
        return this.serviceInfoType;
    }
}

