/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.jdbc.XADataSourceWrapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@EnableConfigurationProperties(value={DataSourceProperties.class})
@ConditionalOnClass(value={DataSource.class, TransactionManager.class, EmbeddedDatabaseType.class})
@ConditionalOnBean(value={XADataSourceWrapper.class})
@ConditionalOnMissingBean(value={DataSource.class})
public class XADataSourceAutoConfiguration
implements BeanClassLoaderAware {
    @Autowired
    private XADataSourceWrapper wrapper;
    @Autowired
    private DataSourceProperties properties;
    @Autowired(required=false)
    private XADataSource xaDataSource;
    private ClassLoader classLoader;

    @Bean
    public DataSource dataSource() throws Exception {
        XADataSource xaDataSource = this.xaDataSource;
        if (xaDataSource == null) {
            xaDataSource = this.createXaDataSource();
        }
        return this.wrapper.wrapDataSource(xaDataSource);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private XADataSource createXaDataSource() {
        String className = this.properties.getXa().getDataSourceClassName();
        if (!StringUtils.hasLength((String)className)) {
            className = DatabaseDriver.fromJdbcUrl((String)this.properties.determineUrl()).getXaDataSourceClassName();
        }
        Assert.state((boolean)StringUtils.hasLength((String)className), (String)"No XA DataSource class name specified");
        XADataSource dataSource = this.createXaDataSourceInstance(className);
        this.bindXaProperties(dataSource, this.properties);
        return dataSource;
    }

    private XADataSource createXaDataSourceInstance(String className) {
        try {
            Class dataSourceClass = ClassUtils.forName((String)className, (ClassLoader)this.classLoader);
            Object instance = BeanUtils.instantiateClass((Class)dataSourceClass);
            Assert.isInstanceOf(XADataSource.class, (Object)instance);
            return (XADataSource)instance;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create XADataSource instance from '" + className + "'");
        }
    }

    private void bindXaProperties(XADataSource target, DataSourceProperties dataSourceProperties) {
        Binder binder = new Binder(new ConfigurationPropertySource[]{this.getBinderSource(dataSourceProperties)});
        binder.bind(ConfigurationPropertyName.EMPTY, Bindable.ofInstance((Object)target));
    }

    private ConfigurationPropertySource getBinderSource(DataSourceProperties dataSourceProperties) {
        MapConfigurationPropertySource source = new MapConfigurationPropertySource();
        source.put((Object)"user", (Object)this.properties.determineUsername());
        source.put((Object)"password", (Object)this.properties.determinePassword());
        source.put((Object)"url", (Object)this.properties.determineUrl());
        source.putAll(dataSourceProperties.getXa().getProperties());
        ConfigurationPropertyNameAliases aliases = new ConfigurationPropertyNameAliases();
        aliases.addAliases("user", new String[]{"username"});
        return source.withAliases(aliases);
    }
}

