/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.system;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorDouble;
import com.googlecode.aviator.runtime.type.AviatorLong;
import com.googlecode.aviator.runtime.type.AviatorObject;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Random;

public class RandomFunction
extends AbstractFunction {
    private static ThreadLocal<Random> randomLocal = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new SecureRandom();
        }
    };

    @Override
    public AviatorObject call(Map<String, Object> env) {
        return AviatorDouble.valueOf(randomLocal.get().nextDouble());
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg) {
        return AviatorLong.valueOf(randomLocal.get().nextInt(FunctionUtils.getNumberValue(arg, env).intValue()));
    }

    @Override
    public String getName() {
        return "rand";
    }
}

