/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.boot.loader.tools.SignalUtils;

public class RunProcess {
    private static final long JUST_ENDED_LIMIT = 500L;
    private File workingDirectory;
    private final String[] command;
    private volatile Process process;
    private volatile long endTime;

    public RunProcess(String ... command) {
        this((File)null, command);
    }

    public RunProcess(File workingDirectory, String ... command) {
        this.workingDirectory = workingDirectory;
        this.command = command;
    }

    public int run(boolean waitForProcess, String ... args) throws IOException {
        return this.run(waitForProcess, Arrays.asList(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected int run(boolean waitForProcess, Collection<String> args) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.command);
        builder.directory(this.workingDirectory);
        builder.command().addAll(args);
        builder.redirectErrorStream(true);
        builder.inheritIO();
        try {
            Process process;
            this.process = process = builder.start();
            SignalUtils.attachSignalHandler(this::handleSigInt);
            if (waitForProcess) {
                try {
                    int n = process.waitFor();
                    return n;
                }
                catch (InterruptedException ex) {
                    int n;
                    block9: {
                        Thread.currentThread().interrupt();
                        n = 1;
                        if (!waitForProcess) break block9;
                        this.endTime = System.currentTimeMillis();
                        this.process = null;
                    }
                    return n;
                }
            }
            int n = 5;
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (waitForProcess) {
                this.endTime = System.currentTimeMillis();
                this.process = null;
            }
        }
    }

    public Process getRunningProcess() {
        return this.process;
    }

    public boolean handleSigInt() {
        if (this.hasJustEnded()) {
            return true;
        }
        return this.doKill();
    }

    public void kill() {
        this.doKill();
    }

    private boolean doKill() {
        Process process = this.process;
        if (process != null) {
            try {
                process.destroy();
                process.waitFor();
                this.process = null;
                return true;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    public boolean hasJustEnded() {
        return System.currentTimeMillis() < this.endTime + 500L;
    }
}

