/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.codahale.metrics.MetricRegistry;
import com.ryantenney.metrics.spring.MethodKey;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

abstract class AbstractMetricMethodInterceptor<A extends Annotation, M>
implements MethodInterceptor,
ReflectionUtils.MethodCallback {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final MetricRegistry metricRegistry;
    private final Class<?> targetClass;
    private final Class<A> annotationClass;
    private final Map<MethodKey, AnnotationMetricPair<A, M>> metrics;

    AbstractMetricMethodInterceptor(MetricRegistry metricRegistry, Class<?> targetClass, Class<A> annotationClass, ReflectionUtils.MethodFilter methodFilter) {
        this.metricRegistry = metricRegistry;
        this.targetClass = targetClass;
        this.annotationClass = annotationClass;
        this.metrics = new HashMap<MethodKey, AnnotationMetricPair<A, M>>();
        this.LOG.debug("Creating method interceptor for class {}", (Object)targetClass.getCanonicalName());
        this.LOG.debug("Scanning for @{} annotated methods", (Object)annotationClass.getSimpleName());
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)this, (ReflectionUtils.MethodFilter)methodFilter);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        AnnotationMetricPair<A, M> annotationMetricPair = this.metrics.get(MethodKey.forMethod(invocation.getMethod()));
        if (annotationMetricPair != null) {
            return this.invoke(invocation, annotationMetricPair.getMeter(), annotationMetricPair.getAnnotation());
        }
        return invocation.proceed();
    }

    public void doWith(Method method) throws IllegalAccessException {
        A annotation = method.getAnnotation(this.annotationClass);
        if (annotation != null) {
            MethodKey methodKey = MethodKey.forMethod(method);
            String metricName = this.buildMetricName(this.targetClass, method, annotation);
            M metric = this.buildMetric(this.metricRegistry, metricName, annotation);
            if (metric != null) {
                this.metrics.put(methodKey, new AnnotationMetricPair<A, M>(annotation, metric));
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Created {} {} for method {}", new Object[]{metric.getClass().getSimpleName(), metricName, methodKey});
                }
            }
        }
    }

    protected abstract String buildMetricName(Class<?> var1, Method var2, A var3);

    protected abstract M buildMetric(MetricRegistry var1, String var2, A var3);

    protected abstract Object invoke(MethodInvocation var1, M var2, A var3) throws Throwable;

    public static final class AnnotationMetricPair<A extends Annotation, M> {
        private final A annotation;
        private final M meter;

        public AnnotationMetricPair(A annotation, M meter) {
            this.annotation = annotation;
            this.meter = meter;
        }

        public A getAnnotation() {
            return this.annotation;
        }

        public M getMeter() {
            return this.meter;
        }
    }
}

