/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.base.Stopwatch;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.grpclb.CachedSubchannelPool;
import io.grpc.grpclb.GrpclbConfig;
import io.grpc.grpclb.GrpclbLoadBalancer;
import io.grpc.grpclb.GrpclbState;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.JsonUtil;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.internal.TimeProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Internal
public final class GrpclbLoadBalancerProvider
extends LoadBalancerProvider {
    private static final GrpclbState.Mode DEFAULT_MODE = GrpclbState.Mode.ROUND_ROBIN;

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "grpclb";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new GrpclbLoadBalancer(helper, new CachedSubchannelPool(helper), TimeProvider.SYSTEM_TIME_PROVIDER, Stopwatch.createUnstarted(), (BackoffPolicy.Provider)new ExponentialBackoffPolicy.Provider());
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingConfigPolicy) {
        try {
            return this.parseLoadBalancingConfigPolicyInternal(rawLoadBalancingConfigPolicy);
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.fromThrowable((Throwable)e).withDescription("Failed to parse GRPCLB config: " + rawLoadBalancingConfigPolicy));
        }
    }

    NameResolver.ConfigOrError parseLoadBalancingConfigPolicyInternal(Map<String, ?> rawLoadBalancingPolicyConfig) {
        if (rawLoadBalancingPolicyConfig == null) {
            return NameResolver.ConfigOrError.fromConfig((Object)GrpclbConfig.create(DEFAULT_MODE));
        }
        String serviceName = JsonUtil.getString(rawLoadBalancingPolicyConfig, (String)"serviceName");
        List rawChildPolicies = JsonUtil.getList(rawLoadBalancingPolicyConfig, (String)"childPolicy");
        List childPolicies = null;
        if (rawChildPolicies != null) {
            childPolicies = ServiceConfigUtil.unwrapLoadBalancingConfigList((List)JsonUtil.checkObjectList((List)rawChildPolicies));
        }
        if (childPolicies == null || childPolicies.isEmpty()) {
            return NameResolver.ConfigOrError.fromConfig((Object)GrpclbConfig.create(DEFAULT_MODE, serviceName));
        }
        ArrayList<String> policiesTried = new ArrayList<String>();
        for (ServiceConfigUtil.LbConfig childPolicy : childPolicies) {
            String childPolicyName;
            switch (childPolicyName = childPolicy.getPolicyName()) {
                case "round_robin": {
                    return NameResolver.ConfigOrError.fromConfig((Object)GrpclbConfig.create(GrpclbState.Mode.ROUND_ROBIN, serviceName));
                }
                case "pick_first": {
                    return NameResolver.ConfigOrError.fromConfig((Object)GrpclbConfig.create(GrpclbState.Mode.PICK_FIRST, serviceName));
                }
            }
            policiesTried.add(childPolicyName);
        }
        return NameResolver.ConfigOrError.fromError((Status)Status.INVALID_ARGUMENT.withDescription("None of " + policiesTried + " specified child policies are available."));
    }
}

