/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ExactPhraseScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SloppyPhraseScorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;

public class MultiPhraseQuery
extends Query {
    private final String field;
    private final Term[][] termArrays;
    private final int[] positions;
    private final int slop;

    private MultiPhraseQuery(String field, Term[][] termArrays, int[] positions, int slop) {
        this.field = field;
        this.termArrays = termArrays;
        this.positions = positions;
        this.slop = slop;
    }

    public int getSlop() {
        return this.slop;
    }

    public Term[][] getTermArrays() {
        return this.termArrays;
    }

    public int[] getPositions() {
        return this.positions;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.termArrays.length == 0) {
            return new MatchNoDocsQuery("empty MultiPhraseQuery");
        }
        if (this.termArrays.length == 1) {
            Term[] terms = this.termArrays[0];
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.setDisableCoord(true);
            for (Term term : terms) {
                builder.add(new TermQuery(term), BooleanClause.Occur.SHOULD);
            }
            return builder.build();
        }
        return super.rewrite(reader);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new MultiPhraseWeight(searcher, needsScores);
    }

    @Override
    public final String toString(String f) {
        StringBuilder buffer = new StringBuilder();
        if (this.field == null || !this.field.equals(f)) {
            buffer.append(this.field);
            buffer.append(":");
        }
        buffer.append("\"");
        int lastPos = -1;
        for (int i = 0; i < this.termArrays.length; ++i) {
            int j;
            Term[] terms = this.termArrays[i];
            int position = this.positions[i];
            if (i != 0) {
                buffer.append(" ");
                for (j = 1; j < position - lastPos; ++j) {
                    buffer.append("? ");
                }
            }
            if (terms.length > 1) {
                buffer.append("(");
                for (j = 0; j < terms.length; ++j) {
                    buffer.append(terms[j].text());
                    if (j >= terms.length - 1) continue;
                    buffer.append(" ");
                }
                buffer.append(")");
            } else {
                buffer.append(terms[0].text());
            }
            lastPos = position;
        }
        buffer.append("\"");
        if (this.slop != 0) {
            buffer.append("~");
            buffer.append(this.slop);
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((MultiPhraseQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(MultiPhraseQuery other) {
        return this.slop == other.slop && this.termArraysEquals(this.termArrays, other.termArrays) && Arrays.equals(this.positions, other.positions);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.slop ^ this.termArraysHashCode() ^ Arrays.hashCode(this.positions);
    }

    private int termArraysHashCode() {
        int hashCode = 1;
        for (Object[] objectArray : this.termArrays) {
            hashCode = 31 * hashCode + (objectArray == null ? 0 : Arrays.hashCode(objectArray));
        }
        return hashCode;
    }

    private boolean termArraysEquals(Term[][] termArrays1, Term[][] termArrays2) {
        if (termArrays1.length != termArrays2.length) {
            return false;
        }
        for (int i = 0; i < termArrays1.length; ++i) {
            Object[] termArray1 = termArrays1[i];
            Object[] termArray2 = termArrays2[i];
            if (termArray1 != null ? Arrays.equals(termArray1, termArray2) : termArray2 == null) continue;
            return false;
        }
        return true;
    }

    static class UnionPostingsEnum
    extends PostingsEnum {
        final DocsQueue docsQueue;
        final long cost;
        final PositionsQueue posQueue = new PositionsQueue();
        int posQueueDoc = -2;
        final PostingsEnum[] subs;

        UnionPostingsEnum(Collection<PostingsEnum> subs) {
            this.docsQueue = new DocsQueue(subs.size());
            long cost = 0L;
            for (PostingsEnum sub : subs) {
                this.docsQueue.add(sub);
                cost += sub.cost();
            }
            this.cost = cost;
            this.subs = subs.toArray(new PostingsEnum[subs.size()]);
        }

        @Override
        public int freq() throws IOException {
            int doc = this.docID();
            if (doc != this.posQueueDoc) {
                this.posQueue.clear();
                for (PostingsEnum sub : this.subs) {
                    if (sub.docID() != doc) continue;
                    int freq = sub.freq();
                    for (int i = 0; i < freq; ++i) {
                        this.posQueue.add(sub.nextPosition());
                    }
                }
                this.posQueue.sort();
                this.posQueueDoc = doc;
            }
            return this.posQueue.size();
        }

        @Override
        public int nextPosition() throws IOException {
            return this.posQueue.next();
        }

        @Override
        public int docID() {
            return ((PostingsEnum)this.docsQueue.top()).docID();
        }

        @Override
        public int nextDoc() throws IOException {
            PostingsEnum top = (PostingsEnum)this.docsQueue.top();
            int doc = top.docID();
            do {
                top.nextDoc();
            } while ((top = (PostingsEnum)this.docsQueue.updateTop()).docID() == doc);
            return top.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            PostingsEnum top = (PostingsEnum)this.docsQueue.top();
            do {
                top.advance(target);
            } while ((top = (PostingsEnum)this.docsQueue.updateTop()).docID() < target);
            return top.docID();
        }

        @Override
        public long cost() {
            return this.cost;
        }

        @Override
        public int startOffset() throws IOException {
            return -1;
        }

        @Override
        public int endOffset() throws IOException {
            return -1;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return null;
        }

        static class PositionsQueue {
            private int arraySize = 16;
            private int index = 0;
            private int size = 0;
            private int[] array = new int[this.arraySize];

            PositionsQueue() {
            }

            void add(int i) {
                if (this.size == this.arraySize) {
                    this.growArray();
                }
                this.array[this.size++] = i;
            }

            int next() {
                return this.array[this.index++];
            }

            void sort() {
                Arrays.sort(this.array, this.index, this.size);
            }

            void clear() {
                this.index = 0;
                this.size = 0;
            }

            int size() {
                return this.size;
            }

            private void growArray() {
                int[] newArray = new int[this.arraySize * 2];
                System.arraycopy(this.array, 0, newArray, 0, this.arraySize);
                this.array = newArray;
                this.arraySize *= 2;
            }
        }

        static class DocsQueue
        extends PriorityQueue<PostingsEnum> {
            DocsQueue(int size) {
                super(size);
            }

            @Override
            public final boolean lessThan(PostingsEnum a, PostingsEnum b) {
                return a.docID() < b.docID();
            }
        }
    }

    private class MultiPhraseWeight
    extends Weight {
        private final Similarity similarity;
        private final Similarity.SimWeight stats;
        private final Map<Term, TermContext> termContexts;
        private final boolean needsScores;

        public MultiPhraseWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            super(MultiPhraseQuery.this);
            this.termContexts = new HashMap<Term, TermContext>();
            this.needsScores = needsScores;
            this.similarity = searcher.getSimilarity(needsScores);
            IndexReaderContext context = searcher.getTopReaderContext();
            ArrayList<TermStatistics> allTermStats = new ArrayList<TermStatistics>();
            Term[][] termArray = MultiPhraseQuery.this.termArrays;
            int n = termArray.length;
            for (int i = 0; i < n; ++i) {
                Term[] terms;
                for (Term term : terms = termArray[i]) {
                    TermContext termContext = this.termContexts.get(term);
                    if (termContext == null) {
                        termContext = TermContext.build(context, term);
                        this.termContexts.put(term, termContext);
                    }
                    allTermStats.add(searcher.termStatistics(term, termContext));
                }
            }
            this.stats = this.similarity.computeWeight(searcher.collectionStatistics(MultiPhraseQuery.this.field), allTermStats.toArray(new TermStatistics[allTermStats.size()]));
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            for (Term[] arr : MultiPhraseQuery.this.termArrays) {
                Collections.addAll(terms, arr);
            }
        }

        @Override
        public float getValueForNormalization() {
            return this.stats.getValueForNormalization();
        }

        @Override
        public void normalize(float queryNorm, float boost) {
            this.stats.normalize(queryNorm, boost);
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            assert (MultiPhraseQuery.this.termArrays.length != 0);
            LeafReader reader = context.reader();
            Comparable[] postingsFreqs = new PhraseQuery.PostingsAndFreq[MultiPhraseQuery.this.termArrays.length];
            Terms fieldTerms = reader.terms(MultiPhraseQuery.this.field);
            if (fieldTerms == null) {
                return null;
            }
            if (!fieldTerms.hasPositions()) {
                throw new IllegalStateException("field \"" + MultiPhraseQuery.this.field + "\" was indexed without position data; cannot run MultiPhraseQuery (phrase=" + this.getQuery() + ")");
            }
            TermsEnum termsEnum = fieldTerms.iterator();
            float totalMatchCost = 0.0f;
            for (int pos = 0; pos < postingsFreqs.length; ++pos) {
                Term[] terms = MultiPhraseQuery.this.termArrays[pos];
                ArrayList<PostingsEnum> postings = new ArrayList<PostingsEnum>();
                for (Term term : terms) {
                    TermState termState = this.termContexts.get(term).get(context.ord);
                    if (termState == null) continue;
                    termsEnum.seekExact(term.bytes(), termState);
                    postings.add(termsEnum.postings(null, 24));
                    totalMatchCost += PhraseQuery.termPositionsCost(termsEnum);
                }
                if (postings.isEmpty()) {
                    return null;
                }
                PostingsEnum postingsEnum = postings.size() == 1 ? (PostingsEnum)postings.get(0) : new UnionPostingsEnum(postings);
                postingsFreqs[pos] = new PhraseQuery.PostingsAndFreq(postingsEnum, MultiPhraseQuery.this.positions[pos], terms);
            }
            if (MultiPhraseQuery.this.slop == 0) {
                ArrayUtil.timSort((Comparable[])postingsFreqs);
            }
            if (MultiPhraseQuery.this.slop == 0) {
                return new ExactPhraseScorer(this, (PhraseQuery.PostingsAndFreq[])postingsFreqs, this.similarity.simScorer(this.stats, context), this.needsScores, totalMatchCost);
            }
            return new SloppyPhraseScorer(this, (PhraseQuery.PostingsAndFreq[])postingsFreqs, MultiPhraseQuery.this.slop, this.similarity.simScorer(this.stats, context), this.needsScores, totalMatchCost);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            Scorer scorer = this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                float freq = MultiPhraseQuery.this.slop == 0 ? (float)scorer.freq() : ((SloppyPhraseScorer)scorer).sloppyFreq();
                Similarity.SimScorer docScorer = this.similarity.simScorer(this.stats, context);
                Explanation freqExplanation = Explanation.match(freq, "phraseFreq=" + freq, new Explanation[0]);
                Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
                return Explanation.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
            }
            return Explanation.noMatch("no matching term", new Explanation[0]);
        }
    }

    public static class Builder {
        private String field;
        private final ArrayList<Term[]> termArrays;
        private final ArrayList<Integer> positions;
        private int slop;

        public Builder() {
            this.field = null;
            this.termArrays = new ArrayList();
            this.positions = new ArrayList();
            this.slop = 0;
        }

        public Builder(MultiPhraseQuery multiPhraseQuery) {
            this.field = multiPhraseQuery.field;
            int length = multiPhraseQuery.termArrays.length;
            this.termArrays = new ArrayList(length);
            this.positions = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                this.termArrays.add(multiPhraseQuery.termArrays[i]);
                this.positions.add(multiPhraseQuery.positions[i]);
            }
            this.slop = multiPhraseQuery.slop;
        }

        public Builder setSlop(int s) {
            if (s < 0) {
                throw new IllegalArgumentException("slop value cannot be negative");
            }
            this.slop = s;
            return this;
        }

        public Builder add(Term term) {
            return this.add(new Term[]{term});
        }

        public Builder add(Term[] terms) {
            int position = 0;
            if (this.positions.size() > 0) {
                position = this.positions.get(this.positions.size() - 1) + 1;
            }
            return this.add(terms, position);
        }

        public Builder add(Term[] terms, int position) {
            Objects.requireNonNull(terms, "Term array must not be null");
            if (this.termArrays.size() == 0) {
                this.field = terms[0].field();
            }
            for (Term term : terms) {
                if (term.field().equals(this.field)) continue;
                throw new IllegalArgumentException("All phrase terms must be in the same field (" + this.field + "): " + term);
            }
            this.termArrays.add(terms);
            this.positions.add(position);
            return this;
        }

        public MultiPhraseQuery build() {
            int[] positionsArray = new int[this.positions.size()];
            for (int i = 0; i < this.positions.size(); ++i) {
                positionsArray[i] = this.positions.get(i);
            }
            Term[][] termArraysArray = (Term[][])this.termArrays.toArray((T[])new Term[this.termArrays.size()][]);
            return new MultiPhraseQuery(this.field, termArraysArray, positionsArray, this.slop);
        }
    }
}

