/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import java.math.MathContext;

public enum Options {
    ALWAYS_USE_DOUBLE_AS_DECIMAL,
    OPTIMIZE_LEVEL,
    MATH_CONTEXT,
    TRACE,
    ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL,
    TRACE_EVAL,
    PUT_CAPTURING_GROUPS_INTO_ENV,
    ENABLE_PROPERTY_SYNTAX_SUGAR,
    NIL_WHEN_PROPERTY_NOT_FOUND,
    USE_USER_ENV_AS_TOP_ENV_DIRECTLY,
    DISABLE_ASSIGNMENT;

    private static final boolean TRACE_DEFAULT_VAL;
    private static final boolean TRACE_EVAL_DEFAULT_VAL;
    public static final Value FALSE_VALUE;
    public static final Value TRUE_VALUE;
    public static final Value DEFAULT_MATH_CONTEXT;
    public static final Value EVAL_VALUE;
    public static final Value COMPILE_VALUE;

    public Object intoObject(Value val) {
        switch (this) {
            case ALWAYS_USE_DOUBLE_AS_DECIMAL: 
            case ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL: 
            case TRACE_EVAL: 
            case PUT_CAPTURING_GROUPS_INTO_ENV: 
            case TRACE: 
            case ENABLE_PROPERTY_SYNTAX_SUGAR: 
            case NIL_WHEN_PROPERTY_NOT_FOUND: 
            case USE_USER_ENV_AS_TOP_ENV_DIRECTLY: 
            case DISABLE_ASSIGNMENT: {
                return val.bool;
            }
            case OPTIMIZE_LEVEL: {
                return val.level;
            }
            case MATH_CONTEXT: {
                return val.mathContext;
            }
        }
        throw new IllegalArgumentException("Fail to cast value " + val + " for option " + (Object)((Object)this));
    }

    public Value intoValue(Object val) {
        switch (this) {
            case ALWAYS_USE_DOUBLE_AS_DECIMAL: 
            case ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL: 
            case TRACE_EVAL: 
            case PUT_CAPTURING_GROUPS_INTO_ENV: 
            case TRACE: 
            case ENABLE_PROPERTY_SYNTAX_SUGAR: 
            case NIL_WHEN_PROPERTY_NOT_FOUND: 
            case USE_USER_ENV_AS_TOP_ENV_DIRECTLY: 
            case DISABLE_ASSIGNMENT: {
                return (Boolean)val != false ? TRUE_VALUE : FALSE_VALUE;
            }
            case OPTIMIZE_LEVEL: {
                int level = (Integer)val;
                if (level == 1) {
                    return EVAL_VALUE;
                }
                return COMPILE_VALUE;
            }
            case MATH_CONTEXT: {
                return new Value((MathContext)val);
            }
        }
        throw new IllegalArgumentException("Fail to cast value " + val + " for option " + (Object)((Object)this));
    }

    public boolean isValidValue(Object val) {
        switch (this) {
            case ALWAYS_USE_DOUBLE_AS_DECIMAL: 
            case ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL: 
            case TRACE_EVAL: 
            case PUT_CAPTURING_GROUPS_INTO_ENV: 
            case TRACE: 
            case ENABLE_PROPERTY_SYNTAX_SUGAR: 
            case NIL_WHEN_PROPERTY_NOT_FOUND: 
            case USE_USER_ENV_AS_TOP_ENV_DIRECTLY: 
            case DISABLE_ASSIGNMENT: {
                return val instanceof Boolean;
            }
            case OPTIMIZE_LEVEL: {
                return val instanceof Integer && ((Integer)val == 1 || (Integer)val == 0);
            }
            case MATH_CONTEXT: {
                return val instanceof MathContext;
            }
        }
        return false;
    }

    public Object getDefaultValue() {
        return this.intoObject(this.getDefaultValueObject());
    }

    public Value getDefaultValueObject() {
        switch (this) {
            case ALWAYS_USE_DOUBLE_AS_DECIMAL: 
            case ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL: {
                return FALSE_VALUE;
            }
            case ENABLE_PROPERTY_SYNTAX_SUGAR: {
                return TRUE_VALUE;
            }
            case NIL_WHEN_PROPERTY_NOT_FOUND: {
                return FALSE_VALUE;
            }
            case OPTIMIZE_LEVEL: {
                return EVAL_VALUE;
            }
            case MATH_CONTEXT: {
                return DEFAULT_MATH_CONTEXT;
            }
            case TRACE_EVAL: {
                return TRACE_EVAL_DEFAULT_VAL ? TRUE_VALUE : FALSE_VALUE;
            }
            case TRACE: {
                return TRACE_DEFAULT_VAL ? TRUE_VALUE : FALSE_VALUE;
            }
            case PUT_CAPTURING_GROUPS_INTO_ENV: {
                return TRUE_VALUE;
            }
            case USE_USER_ENV_AS_TOP_ENV_DIRECTLY: {
                return TRUE_VALUE;
            }
            case DISABLE_ASSIGNMENT: {
                return FALSE_VALUE;
            }
        }
        return null;
    }

    static {
        TRACE_DEFAULT_VAL = Boolean.valueOf(System.getProperty("aviator.asm.trace", "false"));
        TRACE_EVAL_DEFAULT_VAL = Boolean.valueOf(System.getProperty("aviator.trace_eval", "false"));
        FALSE_VALUE = new Value(false);
        TRUE_VALUE = new Value(true);
        DEFAULT_MATH_CONTEXT = new Value(MathContext.DECIMAL128);
        EVAL_VALUE = new Value(1);
        COMPILE_VALUE = new Value(0);
    }

    public static class Value {
        public boolean bool;
        public MathContext mathContext;
        public int level;

        public Value(boolean bool) {
            this.bool = bool;
        }

        public Value(MathContext mathContext) {
            this.mathContext = mathContext;
        }

        public Value(int level) {
            this.level = level;
        }

        public String toString() {
            return "Value [bool=" + this.bool + ", mathContext=" + this.mathContext + ", level=" + this.level + "]";
        }
    }
}

