/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedMember;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;

public class ModelAttributeField {
    private final ResolvedType fieldType;
    private final String name;
    private final List<ResolvedMember<?>> resolvedMembers;

    public ModelAttributeField(ResolvedType fieldType, String name, ResolvedMember<?> primary, ResolvedMember<?> secondary) {
        this.fieldType = fieldType;
        this.name = name;
        this.resolvedMembers = new ArrayList();
        this.resolvedMembers.add(primary);
        if (secondary != null) {
            this.resolvedMembers.add(secondary);
        }
    }

    public ResolvedType getFieldType() {
        return this.fieldType;
    }

    public List<ResolvedMember<?>> getResolvedMembers() {
        return this.resolvedMembers;
    }

    public List<AnnotatedElement> annotatedElements() {
        return FluentIterable.from(this.resolvedMembers).transform(new Function<ResolvedMember<?>, AnnotatedElement>(){

            public AnnotatedElement apply(ResolvedMember<?> input) {
                return (AnnotatedElement)((Object)input.getRawMember());
            }
        }).toList();
    }

    public String getName() {
        return this.name;
    }
}

