/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.utils;

import com.googlecode.aviator.runtime.RuntimeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Map;

public class TypeUtils {
    public static long NEWTON_METHOD_REPEATS = 10000L;

    public static final boolean isBigInt(Object value) {
        return value instanceof BigInteger;
    }

    public static final boolean isDecimal(Object value) {
        return value instanceof BigDecimal;
    }

    public static final boolean isLong(Object value) {
        return value instanceof Integer || value instanceof Long || value instanceof Byte || value instanceof Short;
    }

    public static final boolean isDouble(Object value) {
        return value instanceof Float || value instanceof Double;
    }

    public static final boolean isString(Object value) {
        return value instanceof String || value instanceof Character;
    }

    public static int comapreLong(long x, long y) {
        if (x > y) {
            return 1;
        }
        if (x < y) {
            return -1;
        }
        return 0;
    }

    public static BigDecimal ln(Map<String, Object> env, BigDecimal x) {
        if (x.equals(BigDecimal.ONE)) {
            return BigDecimal.ZERO;
        }
        x = x.subtract(BigDecimal.ONE);
        BigDecimal ret = new BigDecimal(NEWTON_METHOD_REPEATS + 1L);
        MathContext mathContext = RuntimeUtils.getMathContext(env);
        for (long i = NEWTON_METHOD_REPEATS; i >= 0L; --i) {
            BigDecimal N = new BigDecimal(i / 2L + 1L).pow(2);
            N = N.multiply(x, mathContext);
            ret = N.divide(ret, mathContext);
            N = new BigDecimal(i + 1L);
            ret = ret.add(N, mathContext);
        }
        ret = x.divide(ret, mathContext);
        return ret;
    }
}

