/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.csrf;

import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.util.Assert;

public final class DefaultCsrfToken
implements CsrfToken {
    private final String token;
    private final String parameterName;
    private final String headerName;

    public DefaultCsrfToken(String headerName, String parameterName, String token) {
        Assert.hasLength((String)headerName, (String)"headerName cannot be null or empty");
        Assert.hasLength((String)parameterName, (String)"parameterName cannot be null or empty");
        Assert.hasLength((String)token, (String)"token cannot be null or empty");
        this.headerName = headerName;
        this.parameterName = parameterName;
        this.token = token;
    }

    @Override
    public String getHeaderName() {
        return this.headerName;
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof CsrfToken)) {
            return false;
        }
        CsrfToken that = (CsrfToken)o;
        if (!this.getToken().equals(that.getToken())) {
            return false;
        }
        if (!this.getParameterName().equals(that.getParameterName())) {
            return false;
        }
        return this.getHeaderName().equals(that.getHeaderName());
    }

    public int hashCode() {
        int result = this.getToken().hashCode();
        result = 31 * result + this.getParameterName().hashCode();
        result = 31 * result + this.getHeaderName().hashCode();
        return result;
    }
}

